function useWXShare(data) {
  const shareData = Object.assign(
    {
      title: '数字领导力企业家学者DBA申请',
      desc: '权威数字经济专业课程融合国际名校工商管理博士学位，培养数字经济时代下的企业家前瞻力和领导力。',
      link: location.href,
      imgUrl: 'https://webapp-pub.ezijing.com/project/cbu-enterprise/logo.jpg'
    },
    data
  )

  const updateShareData = () => {
    wx.updateAppMessageShareData({
      title: shareData.title,
      desc: shareData.desc,
      link: shareData.link,
      imgUrl: shareData.imgUrl
    })

    wx.updateTimelineShareData({
      title: shareData.title,
      link: shareData.link,
      imgUrl: shareData.imgUrl
    })
  }

  fetch('https://node-server.ezijing.com/share/getsignature', {
    method: 'post',
    headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
    body: JSON.stringify({ appId: 'wxfe67f37095e08d2f', url: location.href.split('#').pop() })
  })
    .then(response => {
      return response.json()
    })
    .then(data => {
      console.log(data)
      wx.config({
        debug: false, // 开启调试模式,调用的所有api的返回值会在客户端alert出来，若要查看传入的参数，可以在pc端打开，参数信息会通过log打出，仅在pc端时才会打印。
        appId: 'wxfe67f37095e08d2f', // 必填，公众号的唯一标识
        timestamp: data.timestamp, // 必填，生成签名的时间戳
        nonceStr: data.noncestr, // 必填，生成签名的随机串
        signature: data.token, // 必填，签名
        jsApiList: ['updateAppMessageShareData', 'updateTimelineShareData'] // 必填，需要使用的JS接口列表
      })
      wx.ready(updateShareData)
    })
}

useWXShare()
