export default function (_this) {
  return {
    required: true,
    id: 'interview_zwjl',
    title: '中文简历',
    get: {
      callback(data) {
        const { attachments = [] } = _this.detail.material
        const RESUME_CN = attachments.filter(item => item.file_type_id === 'RESUME_CN')
        return { RESUME_CN }
      }
    },
    form: {
      hasSubmit: false,
      items: [
        {
          required: true,
          type: 'v-upload',
          model: 'RESUME_CN',
          attrs: {
            action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/put`,
            deleteAction: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/delete`,
            data: { file_type: 'RESUME_CN' }
          },
          append: `
        <p>请下载填写中文简历模板后上传 [<a href="https://webapp-pub.oss-cn-beijing.aliyuncs.com/project/xmn/%E4%B8%AD%E6%96%87%E7%AE%80%E5%8E%86%E6%A8%A1%E6%9D%BF.doc" target="_blank" download="中文简历模板">下载模板</a>]</p>
        <p>请将中文简历填写完存为"pdf"格式上传，文件小于10MB。</p>`
        }
      ]
    }
  }
}
