export default function(_this) {
  return {
    id: 'interview_byzs',
    title: '毕业证书',
    get: {
      action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/${process.env.projectId}`,
      callback(data) {
        const { attachments = [], submission_stage: submissionStage = 'FILLING' } = data.data.material
        const stageList = [
          'FILLING',
          'PREPAYMENT',
          'INTERVIEW_APPLICATION',
          'AUDITION',
          'INTERVIEW',
          'PAYMENT',
          'REGISTRATION',
          'CLOSED'
        ]
        this.form.options.disabled = stageList.findIndex(item => item === submissionStage) > 2
        return attachments.reduce(
          (result, item) => {
            if (item.file_type_id === 'DIPLOMA_CN') {
              result.DIPLOMA_CN.push(item)
            }
            if (item.file_type_id === 'PROOF_READING') {
              result.PROOF_READING.push(item)
            }
            return result
          },
          { DIPLOMA_CN: [], PROOF_READING: [] }
        )
      }
    },
    form: {
      next: { to: { query: { active: 'interview_ywjl' } } },
      hasButton: false,
      options: { 'label-position': 'top' },
      items: [
        {
          label: '毕业证书',
          type: 'v-upload',
          model: 'DIPLOMA_CN',
          attrs: {
            action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/put`,
            deleteAction: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/delete`,
            data: { file_type: 'DIPLOMA_CN' }
          },
          append:
            '申请者需要将本科或以上毕业证书原件扫描或者拍照后提交。<br> 可上传多个文件，请确保证书号码清晰可辨。<br> 上传文件仅限“jpg,jpeg,png”格式，文件小于10MB。'
        },
        {
          label: '在读证明',
          type: 'v-upload',
          model: 'PROOF_READING',
          attrs: {
            action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/put`,
            deleteAction: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/delete`,
            data: { file_type: 'PROOF_READING' }
          },
          append:
            '未毕业学员提交加盖公章的在读证明<br/>申请者需要将本科或以上在读证明原件扫描或拍照后提交。<br> 可上传多个文件，请确保公章清晰可辨。<br> 上传文件仅限“jpg,jpeg,png”格式，文件小于10MB。'
        }
      ]
    }
  }
}
