import { STAGE_LIST } from '../../index'
export default function(_this) {
  return {
    required: true,
    id: 'admission_form',
    title: '申请表格',
    get: {
      action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/${process.env.projectId}`,
      callback(data) {
        const {
          basic_info: basicInfo = {},
          attachments = [],
          submission_stage: submissionStage = 'FILLING'
        } = data.data.material

        this.form.options.disabled = STAGE_LIST.findIndex(item => item === submissionStage) > 6
        const attachment = attachments.reduce(
          (result, item) => {
            if (item.file_type_id === 'APPLICATION_FORM') {
              result.APPLICATION_FORM.push(item)
            }
            return result
          },
          { APPLICATION_FORM: [] }
        )
        return Object.assign({}, basicInfo, attachment)
      }
    },
    update: {
      action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/submit/${process.env.projectId}`,
      beforeRequest(data) {
        return { submission_stage: 'REGISTRATION' }
      },
      callback() {
        this.form.options.disabled = true
        _this.dialogVisible = true
        _this.getApplication()
      },
      errorCallback() {
        _this.completeVisible = true
      }
    },
    form: {
      prev: { to: { query: { active: 'admission_byzs' } } },
      submitText: '提交申请',
      model: { submission_stage: 'REGISTRATION' },
      options: { 'label-position': 'top' },
      items: [
        {
          required: true,
          type: 'v-upload',
          model: 'APPLICATION_FORM',
          attrs: {
            action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/put`,
            deleteAction: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${process.env.projectId}/delete`,
            data: { file_type: 'APPLICATION_FORM' },
            limit: 1
          },
          rules: [{ required: true, message: '请上传', trigger: 'change' }],
          prepend: `<p>请下载填写申请表格（First Year Application Form）模板后上传 <a href="https://webapp-pub.ezijing.com/project/sit-plus/First%20Year%20Application.docx" target="_blank" download="申请表格" style="color:#aa1941;">[下载模板]</a></p>`
        }
      ]
    }
  }
}
