/**
 * 教育背景
 */

export default function(_this) {
  return {
    id: 'application_info_education',
    title: '教育背景',
    required: true,
    visible() {
      return _this.visible
    },
    get: {
      action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/${_this.$store.state.projectId}`,
      callback(data) {
        const { educations: list = [], submission_stage: submissionStage = 'FILLING' } = data.data.material
        this.form.options.disabled = submissionStage !== 'FILLING'
        return list.length ? list : [{}]
      }
    },
    update: {
      action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/${_this.$store.state.projectId}/put`,
      beforeRequest(data) {
        const educations = data.map(item => {
          return ['start_date', 'end_date', 'school_name_cn', 'major_cn', 'degree'].reduce((result, key) => {
            result[key] = item[key]
            return result
          }, {})
        })
        return { educations }
      }
    },
    form: {
      prev: { to: { query: { active: 'application_info', tab: 'application_info_profile' } }, isSubmit: true },
      next: { to: { query: { active: 'application_info', tab: 'application_info_career' } }, isSubmit: true },
      hasAdd: true,
      options: { labelWidth: '140px' },
      items: [
        {
          type: 'v-datepicker',
          label: '开始时间',
          model: 'start_date',
          attrs: {
            type: 'month',
            placeholder: '请选择教育开始时间',
            valueFormat: 'yyyy-MM'
          },
          rules: [{ required: true, message: '请选择教育开始时间', trigger: 'blur' }]
        },
        {
          type: 'v-datepicker',
          label: '结束时间',
          model: 'end_date',
          attrs: {
            type: 'month',
            placeholder: '请选择教育结束时间',
            valueFormat: 'yyyy-MM'
          },
          rules: [{ required: true, message: '请选择教育结束时间', trigger: 'blur' }],
          append: '<p style="color:#606266">在读学生填写预计毕业时间</p>'
        },
        {
          type: 'v-input',
          label: '学校名称',
          model: 'school_name_cn',
          attrs: { placeholder: '请输入学校名称' },
          rules: [{ required: true, message: '请输入学校名称', trigger: 'blur' }]
        },
        {
          type: 'v-input',
          label: '专业名称',
          model: 'major_cn',
          attrs: { placeholder: '请输入专业名称' },
          rules: [{ required: true, message: '请输入专业名称', trigger: 'blur' }]
        },
        {
          type: 'v-select',
          values: [
            { value: '专科' },
            { value: '本科' },
            { value: '本科/学士' },
            { value: '硕士研究生' },
            { value: '研究生/硕士' },
            { value: '博士研究生' },
            { value: '研究生/博士' },
            { value: '其他' }
          ],
          label: '学历/学位',
          model: 'degree',
          rules: [{ required: true, message: '请选择学历/学位', trigger: 'change' }]
        }
      ]
    }
  }
}
