export default function(_this) {
  return {
    id: 'interview_cjd',
    title: '成绩单（中+英）',
    get: {
      action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/${_this.$store.state.projectId}`,
      callback(data) {
        const { attachments = [], submission_stage: submissionStage = 'FILLING' } = data.data.material
        const stageList = [
          'FILLING',
          'PREPAYMENT',
          'INTERVIEW_APPLICATION',
          'AUDITION',
          'INTERVIEW',
          'PAYMENT',
          'REGISTRATION',
          'CLOSED'
        ]
        this.form.options.disabled = stageList.findIndex(item => item === submissionStage) > 2
        return attachments.reduce(
          (result, item) => {
            if (item.file_type_id === 'REPORT_CARD_CN') {
              result.REPORT_CARD_CN.push(item)
            }
            if (item.file_type_id === 'REPORT_CARD_EN') {
              result.REPORT_CARD_EN.push(item)
            }
            return result
          },
          { REPORT_CARD_CN: [], REPORT_CARD_EN: [] }
        )
      }
    },
    form: {
      next: { to: { query: { active: 'interview_ywjl' } } },
      hasButton: false,
      options: { 'label-position': 'top' },
      hint: `
      <p>请将中英文成绩单原件扫描或者拍照后提交。</p>
      <p>获取途径:联系大学时就读学校相关部门(档案馆/教务处)获取成绩单。</p>
    `,
      items: [
        {
          type: 'v-upload',
          label: '中文成绩单',
          model: 'REPORT_CARD_CN',
          attrs: {
            action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${_this.$store.state.projectId}/put`,
            deleteAction: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${_this.$store.state.projectId}/delete`,
            data: { file_type: 'REPORT_CARD_CN' }
          }
        },
        {
          type: 'v-upload',
          label: '英文成绩单',
          model: 'REPORT_CARD_EN',
          attrs: {
            action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${_this.$store.state.projectId}/put`,
            deleteAction: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${_this.$store.state.projectId}/delete`,
            data: { file_type: 'REPORT_CARD_EN' }
          }
        }
      ]
    }
  }
}
