import httpRequest from '@/utils/httpRequest'
import store from '@/store/index'
/**
 * 获取用户信息
 */
export function getUser() {
  return httpRequest.get('/api/passport/account/get-user-info')
}

/**
 * 修改用户信息
 */
export function updateUser(data) {
  return httpRequest.post('/api/usercenter/user/update-user', data)
}

/**
 * 修改密码
 */
export function updatePassword(data) {
  return httpRequest.post('/api/usercenter/user/update-pwd', data)
}

/**
 * 发送验证码
 */
export function sendCode(data) {
  return httpRequest.post('/api/usercenter/user/send-code', data)
}

/**
 * 获取报名信息
 */
export function getApplication(params) {
  return httpRequest.get(`/api/enrollment/v1.0/application-materials/${store().state.projectId}`, { params })
}
/**
 * 获取报名信息
 */
export function updateApplication(data) {
  return httpRequest.post(`/api/enrollment/v1.0/application-materials/${store().state.projectId}/put`, data, {
    headers: { 'Content-Type': 'application/json' }
  })
}

/**
 * 获取报名审核状态
 */
export function getApplicationStatus() {
  return httpRequest.get(`/api/enrollment/v1.0/application-materials/profile/${store().state.projectId}`)
}

/**
 * 获取支付二维码
 */
export function getOrder(params) {
  return httpRequest.get(
    `/api/enrollment/v1.0/application-materials/payment-records/request/${store().state.projectId}/APPLICATION_FEE`,
    { params }
  )
}

/**
 * 检查支付状态
 */
export function checkPay(id, params) {
  return httpRequest.get(
    `/api/enrollment/v1.0/application-materials/payment-records/check-status/${
      store().state.projectId
    }/APPLICATION_FEE/${id}`,
    { params }
  )
}

/**
 * 写推荐信
 */
export function addLetter(userId, letterId, data) {
  return httpRequest.post(
    `/api/enrollment/v1.0/application-materials/reco-letters/submit/${
      store().state.projectId
    }/${userId}/${letterId}/put`,
    data,
    {
      headers: { 'Content-Type': 'application/json' }
    }
  )
}

/**
 * 更换推荐人
 */
export function updateProvider(letterId, data) {
  return httpRequest.post(
    `/api/enrollment/v1.0/application-materials/reco-letters/change-provider/${
      store().state.projectId
    }/${letterId}/put`,
    data,
    {
      headers: { 'Content-Type': 'application/json' }
    }
  )
}
/**
 * 再次邀请
 */
export function sendToProvider(letterId) {
  return httpRequest.get(
    `/api/enrollment/v1.0/application-materials/reco-letters/send-invitation-to-provider/${
      store().state.projectId
    }/${letterId}`
  )
}

/**
 * 发送推荐信
 */
export function sendToProviders() {
  return httpRequest.get(
    `/api/enrollment/v1.0/application-materials/reco-letters/send-invitation-to-providers/${store().state.projectId}`
  )
}
/**
 * 退出登录
 */
export function logout() {
  return httpRequest.get('/api/passport/rest/logout')
}

/**
 * 更改附件状态
 */
export function changeFileStatus(userId, recordId, status) {
  return httpRequest.get(
    `/api/enrollment/v1.0/application-materials/attachments/change-status/${
      store().state.projectId
    }/${userId}/${recordId}`,
    { params: { status } }
  )
}

/**
 * 修改用户信息
 */
export function getOpenId(data) {
  return httpRequest.post('/api/usercenter/v1/wechat/get-openid', data)
}

/**
 * 签名
 */
export function createSign(data) {
  return httpRequest.post('/api/usercenter/v1/sign/sign', data)
}

/**
 * 获取签名文档
 */
export function getSignDocument(params) {
  return httpRequest.get('/api/usercenter/v1/sign/document', { params })
}

/**
 * 获取报名信息
 */
export function getApplicationProfiles(params) {
  return httpRequest.get(`/api/enrollment/v1.0/application-materials/profiles/1016,1022`, { params })
}
