export default function(_this) {
  return {
    id: 'application_wfzzm',
    title: '无犯罪证明',
    visible() {
      return _this.visible
    },
    get: {
      action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/${_this.$store.state.projectId}`,
      callback(data) {
        const { attachments = [], submission_stage: submissionStage = 'FILLING' } = data.data.material
        this.form.options.disabled = submissionStage !== 'FILLING'

        const NO_CRIMINAL_CERT = attachments.filter(item => {
          return item.file_type_id === 'NO_CRIMINAL_CERT'
        })
        return { NO_CRIMINAL_CERT }
      }
    },
    form: {
      prev: { to: { query: { active: 'application_tjx' } } },
      next: { to: { query: { active: 'application_declare' } } },
      hasButton: false,
      options: {},
      items: [
        {
          type: 'v-upload',
          required: true,
          model: 'NO_CRIMINAL_CERT',
          attrs: {
            action: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${_this.$store.state.projectId}/put`,
            deleteAction: `${process.env.baseURL}/api/enrollment/v1.0/application-materials/attachments/${_this.$store.state.projectId}/delete`,
            data: { file_type: 'NO_CRIMINAL_CERT' },
            limit: 1
          },
          prepend: `
          <p>第一步：点击下载按键获取无犯罪证明模板</p>
          <p><a href="https://zws-imgs-pub.ezijing.com/pc/cu/%E6%97%A0%E7%8A%AF%E7%BD%AA%E8%AE%B0%E5%BD%95%E8%AF%81%E6%98%8E.docx" target="_blank" download>下载模板</a></p>
          <p>第二步：打印文件后填写内容并签字上传至电脑，点击下方按钮上传文件</p>
        `
        }
      ]
    }
  }
}
