import Vuex from 'vuex'
import { getUser, logout, getApplicationProfiles } from '@/api/my'
export const state = () => ({
  user: {},
  isMobile: false,
  searchVisible: false,
  menuVisible: false,
  projectId: process.env.projectId
})

export const mutations = {
  setUser(state, user) {
    state.user = user
  },
  removeUser(state) {
    state.user = {}
  },
  setIsMobile(state, isMobile) {
    state.isMobile = isMobile
  },
  toggleSearch(state, visible) {
    state.searchVisible = visible
  },
  toggleMenu(state, visible) {
    state.menuVisible = visible
  },
  setProjectId(state, projectId) {
    state.projectId = projectId
  }
}

export const actions = {
  getUser({ commit }) {
    getUser().then(response => {
      commit('setUser', response.data)
    })
  },
  // 退出登录
  logout({ commit }) {
    logout().then(response => {
      commit('setUser', {})
      this.$router.replace('/')
    })
  },
  // 检测登录状态
  async checkLogin({ commit }) {
    const isLogin = await getUser()
      .then(response => {
        commit('setUser', response.data)
        return true
      })
      .catch(() => {
        commit('setUser', {})
        return false
      })
    return isLogin
  },
  // 设置项目ID
  async setProjectId({ commit }) {
    return getApplicationProfiles().then(response => {
      const [first = {}] = response.data || []
      commit('setProjectId', first.project_id)
      return first.project_id
    })
  }
}

let store

const initStore = () => {
  return (
    store ||
    (store = new Vuex.Store({
      state,
      mutations,
      actions
    }))
  )
}

export default initStore
