import path from 'path'
import fs from 'fs'
import routes from './router/routes'

export default {
  ssr: false,
  env: process.env,
  server: { port: 2048, host: '0.0.0.0' },
  ...(process.env.NODE_ENV === 'development' && {
    server: {
      host: 'dev.ezijing.com',
      https: {
        key: fs.readFileSync(path.resolve(__dirname, 'dev.ezijing.com.key')),
        cert: fs.readFileSync(path.resolve(__dirname, 'dev.ezijing.com.pem'))
      }
    }
  }),
  // Global page headers: https://go.nuxtjs.dev/config-head
  head: {
    title: '索菲亚大学金融方向工商管理硕士项目',
    htmlAttrs: {
      lang: 'en'
    },
    meta: [
      { charset: 'utf-8' },
      { name: 'viewport', content: 'width=device-width, initial-scale=1' },
      { hid: 'description', name: 'description', content: '' },
      {
        name: 'keywords',
        content:
          '索非亚大学,金融方向工商管理硕士,心理学研究,个人心理学'
      },
      {
        name: 'description',
        content:
          '美国索非亚大学创办于1975年，前身是超个人心理学研究所，由毕业于哈佛大学的罗伯特.弗雷格尔博士(Dr.Robert Frager)创办。作为全球第一所超个人心理学顶尖学府，在超个人心理学的研究、整体性及临床教育上，处于全球领导地位。'
      }
    ],
    link: [
      {
        rel: 'icon',
        type: 'image/x-icon',
        href: 'https://zws-imgs-pub.ezijing.com/static/public/f56441ae1441902080226712d4d650aa.ico'
      }
    ]
  },
  // Global CSS: https://go.nuxtjs.dev/config-css
  css: ['vant/lib/index.css', '@ezijing/vue-form/dist/vue-form.css', 'assets/theme/index.css', 'assets/css/base.css'],

  // Plugins to run before rendering page: https://go.nuxtjs.dev/config-plugins
  plugins: [
    '@/plugins/vant',
    '@/plugins/i18n',
    '@/plugins/router',
    '@/plugins/axios',
    '@/plugins/element-ui',
    {
      // 引入一个插件，这里的 ssr 表示使用服务端渲染
      src: 'plugins/vue-swiper.js',
      ssr: false
    }
  ],

  // Auto import components: https://go.nuxtjs.dev/config-components
  components: true,

  // Modules for dev and build (recommended): https://go.nuxtjs.dev/config-modules
  buildModules: [],

  // Modules: https://go.nuxtjs.dev/config-modules
  modules: ['cookie-universal-nuxt'],

  // Build Configuration: https://go.nuxtjs.dev/config-build
  build: {
    transpile: [/^element-ui/]
  },
  router: {
    extendRoutes: routes,
    middleware: ['device', 'i18n']
  }
}
