import { createApp } from 'vue'
import { createPinia } from 'pinia'

import App from './App.vue'
import router from './router'

import ElementPlus from 'element-plus'
import '@/assets/css/theme.scss'
import zhCn from 'element-plus/es/locale/lang/zh-cn'

// 公共css
import './assets/css/base.css'
// 公共组件
import AppCard from '@/components/base/AppCard.vue'
import AppContainer from '@/components/base/AppContainer.vue'

import modules from './modules'

const app = createApp(App)
// 注册公共组件
app.component('AppCard', AppCard).component('AppContainer', AppContainer)

// 注册模块
modules({ router })

app.use(createPinia())
app.use(router)
app.use(ElementPlus, { locale: zhCn })

app.mount('#app')
