import httpRequest from '@/utils/httpRequest'

// 获取新闻列表
export function getNews(params) {
  return httpRequest.get(`/zws/v1/cms/news`, { params })
}

// 获取新闻详情
export function getNew(params) {
  return httpRequest.get(`/zws/v1/cms/new`, { params })
}

/**
 * 发送验证码
 */
export function sendCode(data) {
  return httpRequest.post('/api/usercenter/user/send-code', data)
}

/**
 * 检验验证码
 */
export function checkCode(params) {
  return httpRequest.get('/api/usercenter/user/check-code', { params })
}

/**
 * 提交留咨信息
 */
export function submit(data) {
  return httpRequest.post('/api/enrollment/v1.0/applications', data)
}

/**
 * 获取文章列表
 */
export function getArticleList(params) {
  return httpRequest.get('/api/cms/api/v1/articles', { params })
}

/**
 * 获取图文列表
 */
export function getImgTextList(params) {
  return httpRequest.get('/api/cms/api/v1/img-text', { params })
}
/**
 * 获取用户信息
 */
export function getUser(params = { learning_info: 1 }) {
  return httpRequest.get('/api/usercenter/v2/frontend/user/get-user-info', { params })
}
/**
 * 退出登录
 */
export function logout() {
  return httpRequest.get('/api/passport/rest/logout')
}
