let config = {}
if (process.env.NODE_ENV === 'production') {
  config = {
    server: { port: 2048, host: '0.0.0.0', timing: false }
  }
}
export default {
  ...config,
  env: {
    projectId: '6800242743894343680',
    baseURL: 'https://project-api.ezijing.com'
  },
  axios: {
    baseURL: 'https://project-api.ezijing.com'
  },
  // Global page headers: https://go.nuxtjs.dev/config-head
  head: {
    title: '紫荆教育-清华控股旗下在线教育品牌',
    htmlAttrs: {
      lang: 'en'
    },
    meta: [
      { charset: 'utf-8' },
      {
        name: 'viewport',
        content: 'width=device-width, initial-scale=1.0, maximum-scale=1.0, minimum-scale=1.0, viewport-fit=cover'
      },
      {
        name: 'keywords',
        content:
          '工商管理硕士,MBA硕士,免联考MBA,国际MBA,通用MBA,在职MBA,在线MBA,MBA,美国MBA,教育学硕士,金融硕士,心理学硕士,应用心理学硕士,在职心理学硕士,国际教育学硕士,在职金融硕士,在线心理学硕士,在职教育学硕士,国际金融硕士,美国教育学硕士,在职应用心理学硕士,教育学硕士学位,美国心理学硕士,在职工商管理硕士,酒店管理硕士,在职酒店管理硕士,理财规划师,企业理财顾问师,投资理财顾问,金融理财师,理财培训,企业融资,国家理财规划师,财富管理,资产管理,个人财富管理,证券投资,信托投资,房地产投资'
      },
      {
        name: 'description',
        content:
          '紫荆教育-清华控股旗下在线教育品牌。公司于2015年以清华大学五道口金融学院相关知识产权创设而成。通过研发和应用领先的教育科技，链接全球先进、前沿教育资源，提供高端国际学位教育、职业教育和在线教育解决方案，为我国培养具有国际化视野和全球化思维的复合型和产业型高质量人才。'
      }
    ],
    link: [
      {
        rel: 'icon',
        type: 'image/x-icon',
        href: 'https://zws-imgs-pub.ezijing.com/static/public/f56441ae1441902080226712d4d650aa.ico'
      }
    ]
  },

  // Global CSS: https://go.nuxtjs.dev/config-css
  css: ['vant/lib/index.css', 'swiper/css/swiper.css', '@/assets/css/base.css'],

  // Plugins to run before rendering page: https://go.nuxtjs.dev/config-plugins
  plugins: ['@/plugins/i18n', '@/plugins/axios', '@/plugins/vant', { src: '@/plugins/swiper' }],

  // Auto import components: https://go.nuxtjs.dev/config-components
  components: true,

  // Modules for dev and build (recommended): https://go.nuxtjs.dev/config-modules
  buildModules: [],

  // Modules: https://go.nuxtjs.dev/config-modules
  modules: ['@nuxtjs/axios', 'cookie-universal-nuxt'],

  // Build Configuration: https://go.nuxtjs.dev/config-build
  build: {},
  router: {
    middleware: ['i18n', 'route']
  }
}
