export const state = () => ({
  searchVisible: false,
  menuVisible: false,
  locales: ['zh-CN', 'en-US'],
  locale: 'zh-CN'
})

export const mutations = {
  toggleSearch(state, visible) {
    state.searchVisible = visible
  },
  toggleMenu(state, visible) {
    state.menuVisible = visible
  },
  setLocale(state, locale) {
    if (state.locales.includes(locale)) {
      state.locale = locale
    }
  }
}

export const actions = {
  switchLocale({ commit }, locale) {
    commit('setLocale', locale)
    this.app.i18n.locale = locale
    this.$cookies.set('lang', locale, { domain: 'ezijing.com' })
  }
}
