import Vue from 'vue'
import Router from 'vue-router'
import { normalizeURL, decode } from 'ufo'
import { interopDefault } from './utils'
import scrollBehavior from './router.scrollBehavior.js'

const _2dc5f64c = () => interopDefault(import('../pages/alumnus/index.vue' /* webpackChunkName: "pages/alumnus/index" */))
const _44b59cfe = () => interopDefault(import('../pages/about/contact.vue' /* webpackChunkName: "pages/about/contact" */))
const _10a7578c = () => interopDefault(import('../pages/about/culture.vue' /* webpackChunkName: "pages/about/culture" */))
const _23d2f0fd = () => interopDefault(import('../pages/about/introduce.vue' /* webpackChunkName: "pages/about/introduce" */))
const _7f16db65 = () => interopDefault(import('../pages/about/news.vue' /* webpackChunkName: "pages/about/news" */))
const _249d262e = () => interopDefault(import('../pages/about/news-detail.vue' /* webpackChunkName: "pages/about/news-detail" */))
const _4d95ac32 = () => interopDefault(import('../pages/index.vue' /* webpackChunkName: "pages/index" */))

const emptyFn = () => {}

Vue.use(Router)

export const routerOptions = {
  mode: 'history',
  base: '/',
  linkActiveClass: 'nuxt-link-active',
  linkExactActiveClass: 'nuxt-link-exact-active',
  scrollBehavior,

  routes: [{
    path: "/alumnus",
    component: _2dc5f64c,
    name: "alumnus"
  }, {
    path: "/about/contact",
    component: _44b59cfe,
    name: "about-contact"
  }, {
    path: "/about/culture",
    component: _10a7578c,
    name: "about-culture"
  }, {
    path: "/about/introduce",
    component: _23d2f0fd,
    name: "about-introduce"
  }, {
    path: "/about/news",
    component: _7f16db65,
    name: "about-news"
  }, {
    path: "/about/news-detail",
    component: _249d262e,
    name: "about-news-detail"
  }, {
    path: "/",
    component: _4d95ac32,
    name: "index"
  }],

  fallback: false
}

export function createRouter (ssrContext, config) {
  const base = (config._app && config._app.basePath) || routerOptions.base
  const router = new Router({ ...routerOptions, base  })

  // TODO: remove in Nuxt 3
  const originalPush = router.push
  router.push = function push (location, onComplete = emptyFn, onAbort) {
    return originalPush.call(this, location, onComplete, onAbort)
  }

  const resolve = router.resolve.bind(router)
  router.resolve = (to, current, append) => {
    if (typeof to === 'string') {
      to = normalizeURL(to)
    }
    return resolve(to, current, append)
  }

  return router
}
