import Vue from 'vue'
import Router from 'vue-router'
import { normalizeURL, decode } from 'ufo'
import { interopDefault } from './utils'
import scrollBehavior from './router.scrollBehavior.js'

const _57a4425d = () => interopDefault(import('../pages/alumnus/index.vue' /* webpackChunkName: "pages/alumnus/index" */))
const _6e93e90f = () => interopDefault(import('../pages/about/contact.vue' /* webpackChunkName: "pages/about/contact" */))
const _3a85a39d = () => interopDefault(import('../pages/about/culture.vue' /* webpackChunkName: "pages/about/culture" */))
const _4f4e7cce = () => interopDefault(import('../pages/about/introduce.vue' /* webpackChunkName: "pages/about/introduce" */))
const _347570f4 = () => interopDefault(import('../pages/about/news.vue' /* webpackChunkName: "pages/about/news" */))
const _2879487a = () => interopDefault(import('../pages/about/news-detail.vue' /* webpackChunkName: "pages/about/news-detail" */))
const _43259943 = () => interopDefault(import('../pages/index.vue' /* webpackChunkName: "pages/index" */))

const emptyFn = () => {}

Vue.use(Router)

export const routerOptions = {
  mode: 'history',
  base: '/',
  linkActiveClass: 'nuxt-link-active',
  linkExactActiveClass: 'nuxt-link-exact-active',
  scrollBehavior,

  routes: [{
    path: "/alumnus",
    component: _57a4425d,
    name: "alumnus"
  }, {
    path: "/about/contact",
    component: _6e93e90f,
    name: "about-contact"
  }, {
    path: "/about/culture",
    component: _3a85a39d,
    name: "about-culture"
  }, {
    path: "/about/introduce",
    component: _4f4e7cce,
    name: "about-introduce"
  }, {
    path: "/about/news",
    component: _347570f4,
    name: "about-news"
  }, {
    path: "/about/news-detail",
    component: _2879487a,
    name: "about-news-detail"
  }, {
    path: "/",
    component: _43259943,
    name: "index"
  }],

  fallback: false
}

export function createRouter (ssrContext, config) {
  const base = (config._app && config._app.basePath) || routerOptions.base
  const router = new Router({ ...routerOptions, base  })

  // TODO: remove in Nuxt 3
  const originalPush = router.push
  router.push = function push (location, onComplete = emptyFn, onAbort) {
    return originalPush.call(this, location, onComplete, onAbort)
  }

  const resolve = router.resolve.bind(router)
  router.resolve = (to, current, append) => {
    if (typeof to === 'string') {
      to = normalizeURL(to)
    }
    return resolve(to, current, append)
  }

  return router
}
