import path from 'path'
import fs from 'fs'
let config = {}
if (process.env.NODE_ENV === 'production') {
  config = {
    server: { port: 2048, host: '0.0.0.0', timing: false },
    axios: {
      baseURL: 'https://project-api.ezijing.com',
    }
  }
} else {
  config = {
    axios: {
      proxy: true
    },
    server: {
      port: 3000,
      host: 'dev.ezijing.com',
      timing: false,
      https: {
        key: fs.readFileSync(path.resolve(__dirname, 'dev.ezijing.com.key')),
        cert: fs.readFileSync(path.resolve(__dirname, 'dev.ezijing.com.pem'))
      }
    },
    proxy: {
      '/api': {
        target: 'https://project-api.ezijing.com/api',
        selfHandleResponse: false,
        secure: false,
        changeOrigin: true,
        followRedirects: true,
        logLevel: 'info',
        headers: {
          'Referer': 'https://project-api.ezijing.com/api'
        },
        pathRewrite: {
          '^/api': '/'
        }
      }
    }
  }
}
export default {
  ...config,
  // Global page headers: https://go.nuxtjs.dev/config-head
  head: {
    title: '紫荆教育-在线MBA课程-MBA在线课程-专业金融在线教育品牌',
    htmlAttrs: {
      lang: 'en'
    },
    meta: [
      { charset: 'utf-8' },
      { name: 'viewport', content: 'width=device-width, initial-scale=1' },
      { hid: 'description', name: 'description', content: '' },
      {
        name: 'keywords',
        content:
          '理财规划师,企业理财顾问师,投资理财顾问,金融理财师,理财培训,企业融资,国家理财规划师,财富管理,资产管理,个人财富管理,证券投资,信托投资,房地产投资'
      },
      {
        name: 'description',
        content:
          '紫荆教育依托清华大学和五道口金融学院丰富的教育资源,秉承其严谨务实的教学理念,紧密结合宏观经济转型过程中,企业和个人知识结构升级的需求,融理论大家、实践专家、顶尖专业机构集体智慧于一体,构建以金融为核心的商业实战知识体系,努力为中国社会商业素质提高贡献一己之力.课程分类：企业理财顾问(CFC),理财规划师,财富资产管理,金融创业投资项目.'
      }
    ],
    link: [
      {
        rel: 'icon',
        type: 'image/x-icon',
        href: 'https://zws-imgs-pub.ezijing.com/static/public/f56441ae1441902080226712d4d650aa.ico'
      }
    ]
  },
  // Global CSS: https://go.nuxtjs.dev/config-css
  css: [
    'element-ui/lib/theme-chalk/index.css',
    'assets/css/base.css'
  ],

  // Plugins to run before rendering page: https://go.nuxtjs.dev/config-plugins
  plugins: [
    '@/plugins/element-ui',
    {
      // 引入一个插件，这里的 ssr 表示使用服务端渲染
      src: "plugins/vue-swiper.js", ssr: false
    }
  ],

  // Auto import components: https://go.nuxtjs.dev/config-components
  components: true,

  // Modules for dev and build (recommended): https://go.nuxtjs.dev/config-modules
  buildModules: [
  ],

  // Modules: https://go.nuxtjs.dev/config-modules
  modules: [
    '@nuxtjs/axios'
  ],

  // Build Configuration: https://go.nuxtjs.dev/config-build
  build: {
    transpile: [/^element-ui/],
  }
  // proxy: {
  //   '/api': {
  //     target: 'https://project-api.ezijing.com/api',
  //     selfHandleResponse: false,
  //     secure: false,
  //     changeOrigin: true,
  //     followRedirects: true,
  //     logLevel: 'info',
  //     headers: {
  //       'Referer': 'https://project-api.ezijing.com/api'
  //     },
  //     pathRewrite: {
  //       '^/api': '/'
  //     }
  //   }
  // }
}
