export const state = () => ({
  locales: ['zh-CN', 'en-US'],
  locale: 'zh-CN'
})

export const mutations = {
  setLocale(state, locale) {
    if (state.locales.includes(locale)) {
      state.locale = locale
    }
  }
}

export const actions = {
  switchLocale({ commit }, locale) {
    commit('setLocale', locale)
    this.app.i18n.locale = locale
    this.app.$cookies.set('lang', locale)
    // process.client && location.reload()
  }
}
