import path from 'path'
import fs from 'fs'
let config = {}
if (process.env.NODE_ENV === 'production') {
  config = {
    env: {
      projectId: '6800242743894343680',
      baseURL: 'https://project-api.ezijing.com'
    },
    server: { port: 2048, host: '0.0.0.0', timing: false }
  }
} else {
  config = {
    env: {
      projectId: '6800242743894343680',
      baseURL: 'https://project-api.ezijing.com'
    },
    axios: {
      proxy: true
    },
    server: {
      port: 3000,
      host: 'dev.ezijing.com',
      timing: false,
      https: {
        key: fs.readFileSync(path.resolve(__dirname, 'dev.ezijing.com.key')),
        cert: fs.readFileSync(path.resolve(__dirname, 'dev.ezijing.com.pem'))
      }
    },
    proxy: {
      '/api': {
        target: 'https://project-api.ezijing.com/api',
        selfHandleResponse: false,
        secure: false,
        changeOrigin: true,
        followRedirects: true,
        logLevel: 'info',
        headers: {
          'Referer': 'https://project-api.ezijing.com/api'
        },
        pathRewrite: {
          '^/api': '/'
        }
      }
    }
  }
}
export default {
  ...config,
  // Global page headers: https://go.nuxtjs.dev/config-head
  head: {
    title: '紫荆教育-专注国际学位教育-清华控股旗下在线教育品牌',
    htmlAttrs: {
      lang: 'en'
    },
    meta: [
      { charset: 'utf-8' },
      { name: 'viewport', id: 'viewport', content: 'initial-scale=-1,maximum-scale=1,shrink-to-fit=no' },
      { hid: 'description', name: 'description', content: '' },
      {
        name: 'keywords',
        content:
          '工商管理硕士,MBA硕士,免联考MBA,国际MBA,通用MBA,在职MBA,在线MBA,MBA,美国MBA,金融硕士,金融硕士,心理学硕士,应用心理学硕士,在职心理学硕士,国际金融硕士,在职金融硕士,在线心理学硕士,在职金融硕士,国际金融硕士,美国金融硕士,在职应用心理学硕士,金融硕士学位,美国心理学硕士,在职工商管理硕士,酒店管理硕士,在职酒店管理硕士,理财规划师,企业理财顾问师,投资理财顾问,金融理财师,理财培训,企业融资,国家理财规划师,财富管理,资产管理,个人财富管理,证券投资,信托投资,私人财富风险管理顾问'
      },
      {
        name: 'description',
        content:
          '紫荆教育,专注国际学位教育,不出国、免联考在职读国际学位课程!清华控股旗下在线教育品牌-成立于2015年,全称是“清控紫荆(北京)教育科技股份有限公司”,通过在线教育的方式,将全球优质的教育资源高效、低成本的分发给每个需要的人.'
      }
    ],
    link: [
      {
        rel: 'icon',
        type: 'image/x-icon',
        href: 'https://zws-imgs-pub.ezijing.com/static/public/f56441ae1441902080226712d4d650aa.ico'
      }
    ]
  },
  // Global CSS: https://go.nuxtjs.dev/config-css
  css: [
    'element-ui/lib/theme-chalk/index.css',
    'assets/css/base.css'
  ],

  // Plugins to run before rendering page: https://go.nuxtjs.dev/config-plugins
  plugins: [
    '@/plugins/axios',
    '@/plugins/element-ui',
    {
      // 引入一个插件，这里的 ssr 表示使用服务端渲染
      src: "plugins/vue-swiper.js", ssr: false
    }
  ],

  // Auto import components: https://go.nuxtjs.dev/config-components
  components: true,

  // Modules for dev and build (recommended): https://go.nuxtjs.dev/config-modules
  buildModules: [
  ],

  // Modules: https://go.nuxtjs.dev/config-modules
  modules: [
  ],

  // Build Configuration: https://go.nuxtjs.dev/config-build
  build: {
    transpile: [/^element-ui/],
  }
  // proxy: {
  //   '/api': {
  //     target: 'https://project-api.ezijing.com/api',
  //     selfHandleResponse: false,
  //     secure: false,
  //     changeOrigin: true,
  //     followRedirects: true,
  //     logLevel: 'info',
  //     headers: {
  //       'Referer': 'https://project-api.ezijing.com/api'
  //     },
  //     pathRewrite: {
  //       '^/api': '/'
  //     }
  //   }
  // }
}
