import Vue from 'vue'
import Router from 'vue-router'
import { normalizeURL, decode } from 'ufo'
import { interopDefault } from './utils'
import scrollBehavior from './router.scrollBehavior.js'

const _2dc5f64c = () => interopDefault(import('../pages/alumnus/index.vue' /* webpackChunkName: "pages/alumnus/index" */))
const _44b59cfe = () => interopDefault(import('../pages/about/contact.vue' /* webpackChunkName: "pages/about/contact" */))
const _10a7578c = () => interopDefault(import('../pages/about/culture.vue' /* webpackChunkName: "pages/about/culture" */))
const _23d2f0fd = () => interopDefault(import('../pages/about/introduce.vue' /* webpackChunkName: "pages/about/introduce" */))
const _3de88228 = () => interopDefault(import('../pages/about/news/index.vue' /* webpackChunkName: "pages/about/news/index" */))
const _12856c94 = () => interopDefault(import('../pages/services/college.vue' /* webpackChunkName: "pages/services/college" */))
const _3cf993c6 = () => interopDefault(import('../pages/services/employment.vue' /* webpackChunkName: "pages/services/employment" */))
const _5bfd9c5c = () => interopDefault(import('../pages/services/job.vue' /* webpackChunkName: "pages/services/job" */))
const _77495298 = () => interopDefault(import('../pages/services/major.vue' /* webpackChunkName: "pages/services/major" */))
const _aafe22e0 = () => interopDefault(import('../pages/about/news/_id.vue' /* webpackChunkName: "pages/about/news/_id" */))
const _4d95ac32 = () => interopDefault(import('../pages/index.vue' /* webpackChunkName: "pages/index" */))

const emptyFn = () => {}

Vue.use(Router)

export const routerOptions = {
  mode: 'history',
  base: '/',
  linkActiveClass: 'nuxt-link-active',
  linkExactActiveClass: 'nuxt-link-exact-active',
  scrollBehavior,

  routes: [{
    path: "/alumnus",
    component: _2dc5f64c,
    name: "alumnus"
  }, {
    path: "/about/contact",
    component: _44b59cfe,
    name: "about-contact"
  }, {
    path: "/about/culture",
    component: _10a7578c,
    name: "about-culture"
  }, {
    path: "/about/introduce",
    component: _23d2f0fd,
    name: "about-introduce"
  }, {
    path: "/about/news",
    component: _3de88228,
    name: "about-news"
  }, {
    path: "/services/college",
    component: _12856c94,
    name: "services-college"
  }, {
    path: "/services/employment",
    component: _3cf993c6,
    name: "services-employment"
  }, {
    path: "/services/job",
    component: _5bfd9c5c,
    name: "services-job"
  }, {
    path: "/services/major",
    component: _77495298,
    name: "services-major"
  }, {
    path: "/about/news/:id",
    component: _aafe22e0,
    name: "about-news-id"
  }, {
    path: "/",
    component: _4d95ac32,
    name: "index"
  }],

  fallback: false
}

export function createRouter (ssrContext, config) {
  const base = (config._app && config._app.basePath) || routerOptions.base
  const router = new Router({ ...routerOptions, base  })

  // TODO: remove in Nuxt 3
  const originalPush = router.push
  router.push = function push (location, onComplete = emptyFn, onAbort) {
    return originalPush.call(this, location, onComplete, onAbort)
  }

  const resolve = router.resolve.bind(router)
  router.resolve = (to, current, append) => {
    if (typeof to === 'string') {
      to = normalizeURL(to)
    }
    return resolve(to, current, append)
  }

  return router
}
