import Vue from 'vue'
import { wrapFunctional } from './utils'

const components = {
  Foot: () => import('../../components/Foot.vue' /* webpackChunkName: "components/foot" */).then(c => wrapFunctional(c.default || c)),
  Head: () => import('../../components/Head.vue' /* webpackChunkName: "components/head" */).then(c => wrapFunctional(c.default || c)),
  RightAside: () => import('../../components/RightAside.vue' /* webpackChunkName: "components/right-aside" */).then(c => wrapFunctional(c.default || c)),
  AboutContact: () => import('../../components/about/contact.vue' /* webpackChunkName: "components/about-contact" */).then(c => wrapFunctional(c.default || c)),
  AboutCulture: () => import('../../components/about/culture.vue' /* webpackChunkName: "components/about-culture" */).then(c => wrapFunctional(c.default || c)),
  AboutDetail: () => import('../../components/about/detail.vue' /* webpackChunkName: "components/about-detail" */).then(c => wrapFunctional(c.default || c)),
  AboutIntroduce: () => import('../../components/about/introduce.vue' /* webpackChunkName: "components/about-introduce" */).then(c => wrapFunctional(c.default || c)),
  AboutNews: () => import('../../components/about/news.vue' /* webpackChunkName: "components/about-news" */).then(c => wrapFunctional(c.default || c)),
  AboutTabNav: () => import('../../components/about/tabNav.vue' /* webpackChunkName: "components/about-tab-nav" */).then(c => wrapFunctional(c.default || c)),
  AlumnusParty: () => import('../../components/alumnus/party.vue' /* webpackChunkName: "components/alumnus-party" */).then(c => wrapFunctional(c.default || c)),
  AlumnusTabNav: () => import('../../components/alumnus/tabNav.vue' /* webpackChunkName: "components/alumnus-tab-nav" */).then(c => wrapFunctional(c.default || c)),
  ServicesTab: () => import('../../components/services/tab.vue' /* webpackChunkName: "components/services-tab" */).then(c => wrapFunctional(c.default || c)),
  HomeAlumniStories: () => import('../../components/home/alumniStories.vue' /* webpackChunkName: "components/home-alumni-stories" */).then(c => wrapFunctional(c.default || c)),
  HomeBanner: () => import('../../components/home/banner.vue' /* webpackChunkName: "components/home-banner" */).then(c => wrapFunctional(c.default || c)),
  HomeDegreeEducation: () => import('../../components/home/degreeEducation.vue' /* webpackChunkName: "components/home-degree-education" */).then(c => wrapFunctional(c.default || c)),
  HomeEducationServices: () => import('../../components/home/educationServices.vue' /* webpackChunkName: "components/home-education-services" */).then(c => wrapFunctional(c.default || c)),
  HomeHeadmasterMsg: () => import('../../components/home/headmasterMsg.vue' /* webpackChunkName: "components/home-headmaster-msg" */).then(c => wrapFunctional(c.default || c)),
  HomeOpenClass: () => import('../../components/home/openClass.vue' /* webpackChunkName: "components/home-open-class" */).then(c => wrapFunctional(c.default || c)),
  HomeProjectNotice: () => import('../../components/home/projectNotice.vue' /* webpackChunkName: "components/home-project-notice" */).then(c => wrapFunctional(c.default || c)),
  HomeServiceCase: () => import('../../components/home/serviceCase.vue' /* webpackChunkName: "components/home-service-case" */).then(c => wrapFunctional(c.default || c))
}

for (const name in components) {
  Vue.component(name, components[name])
  Vue.component('Lazy' + name, components[name])
}
