import Vue from 'vue'
import Router from 'vue-router'
import { normalizeURL, decode } from 'ufo'
import { interopDefault } from './utils'
import scrollBehavior from './router.scrollBehavior.js'

const _57a4425d = () => interopDefault(import('../pages/alumnus/index.vue' /* webpackChunkName: "pages/alumnus/index" */))
const _6e93e90f = () => interopDefault(import('../pages/about/contact.vue' /* webpackChunkName: "pages/about/contact" */))
const _3a85a39d = () => interopDefault(import('../pages/about/culture.vue' /* webpackChunkName: "pages/about/culture" */))
const _4f4e7cce = () => interopDefault(import('../pages/about/introduce.vue' /* webpackChunkName: "pages/about/introduce" */))
const _fc431f12 = () => interopDefault(import('../pages/about/news/index.vue' /* webpackChunkName: "pages/about/news/index" */))
const _3ab33805 = () => interopDefault(import('../pages/services/college.vue' /* webpackChunkName: "pages/services/college" */))
const _ec7b1d24 = () => interopDefault(import('../pages/services/employment.vue' /* webpackChunkName: "pages/services/employment" */))
const _340d0a2b = () => interopDefault(import('../pages/services/job.vue' /* webpackChunkName: "pages/services/job" */))
const _ed96eeb2 = () => interopDefault(import('../pages/services/major.vue' /* webpackChunkName: "pages/services/major" */))
const _8727b6c2 = () => interopDefault(import('../pages/about/news/_id.vue' /* webpackChunkName: "pages/about/news/_id" */))
const _43259943 = () => interopDefault(import('../pages/index.vue' /* webpackChunkName: "pages/index" */))

const emptyFn = () => {}

Vue.use(Router)

export const routerOptions = {
  mode: 'history',
  base: '/',
  linkActiveClass: 'nuxt-link-active',
  linkExactActiveClass: 'nuxt-link-exact-active',
  scrollBehavior,

  routes: [{
    path: "/alumnus",
    component: _57a4425d,
    name: "alumnus"
  }, {
    path: "/about/contact",
    component: _6e93e90f,
    name: "about-contact"
  }, {
    path: "/about/culture",
    component: _3a85a39d,
    name: "about-culture"
  }, {
    path: "/about/introduce",
    component: _4f4e7cce,
    name: "about-introduce"
  }, {
    path: "/about/news",
    component: _fc431f12,
    name: "about-news"
  }, {
    path: "/services/college",
    component: _3ab33805,
    name: "services-college"
  }, {
    path: "/services/employment",
    component: _ec7b1d24,
    name: "services-employment"
  }, {
    path: "/services/job",
    component: _340d0a2b,
    name: "services-job"
  }, {
    path: "/services/major",
    component: _ed96eeb2,
    name: "services-major"
  }, {
    path: "/about/news/:id",
    component: _8727b6c2,
    name: "about-news-id"
  }, {
    path: "/",
    component: _43259943,
    name: "index"
  }],

  fallback: false
}

export function createRouter (ssrContext, config) {
  const base = (config._app && config._app.basePath) || routerOptions.base
  const router = new Router({ ...routerOptions, base  })

  // TODO: remove in Nuxt 3
  const originalPush = router.push
  router.push = function push (location, onComplete = emptyFn, onAbort) {
    return originalPush.call(this, location, onComplete, onAbort)
  }

  const resolve = router.resolve.bind(router)
  router.resolve = (to, current, append) => {
    if (typeof to === 'string') {
      to = normalizeURL(to)
    }
    return resolve(to, current, append)
  }

  return router
}
