import httpRequest from '@/utils/axios'

// 获取实验旅程中的群组列表
export function getGroupsList() {
  return httpRequest.get('/api/lab/v1/experiment/itinerary/groups')
}

// 获取实验旅程中的属性列表
export function getAttrList() {
  return httpRequest.get('/api/lab/v1/experiment/itinerary/user-attr')
}

// 链接列表
export function getConnectionList(params: { created_operator?: string; type?: string; page?: number; page_size?: number }) {
  return httpRequest.get('/api/lab/v1/experiment/connection/list', { params })
}

// 标签列表
export function getTagsList() {
  return httpRequest.get('/api/lab/v1/experiment/itinerary/tags')
}

// 时间列表
export function getEventsList() {
  return httpRequest.get('/api/lab/v1/experiment/itinerary/events')
}
