// 组件基础数据
export interface ComponentBaseData {
  name: string
  type: string
  score?: number
  answer_analysis?: string
}

// 立即触发
export interface RealTimeTriggerData extends ComponentBaseData {
  trigger_type: string
  time: string
  time_rule?: string
  time_rule_value?: string
  time_range?: [string, string]
}

// 加入群组
export interface JoinGroupData extends ComponentBaseData {
  group_id: string
}

// 移除群组
export type LeaveGroupData = JoinGroupData

// 变更属性
export interface ChangePropsData extends ComponentBaseData {
  attr_id: string
  operate: string
  value: string
}

// 公众号
export interface OffiaccountData extends ComponentBaseData {
  operate: string
  account: string
  message: string
}

// 内部通知
export interface NoticeData extends ComponentBaseData {
  message: string
}
