import httpRequest from '@/utils/axios'
import type {
  GroupListRequest,
  StaticGroupCreateRequest,
  StaticGroupUpdateRequest,
  DynamicGroupCreateRequest,
  DynamicGroupUpdateRequest
} from './types'

// 获取群组列表
export function getGroupList(params?: GroupListRequest) {
  return httpRequest.get('/api/lab/v1/experiment/group/list', { params })
}

// 获取群组详情
export function getGroupInfo(params: { id: string }) {
  return httpRequest.get('/api/lab/v1/experiment/group/detail', { params })
}

// 创建静态群组
export function createStaticGroup(data: StaticGroupCreateRequest) {
  return httpRequest.post('/api/lab/v1/experiment/group/create-static-group', data)
}

// 创建动态群组
export function createDynamicGroup(data: DynamicGroupCreateRequest) {
  return httpRequest.post('/api/lab/v1/experiment/group/create-dynamic-group', data)
}

// 更新静态群组
export function updateStaticGroup(data: StaticGroupUpdateRequest) {
  return httpRequest.post('/api/lab/v1/experiment/group/update-static-group', data)
}

// 更新动态群组
export function updateDynamicGroup(data: DynamicGroupUpdateRequest) {
  return httpRequest.post('/api/lab/v1/experiment/group/update-dynamic-group', data)
}

// 删除群组
export function deleteGroup(data: { ids: string[] }) {
  return httpRequest.post('/api/lab/v1/experiment/group/delete', data)
}

// 获取群组数据信息
export function getGroupStatistics(params: { group_id: string }) {
  return httpRequest.get('/api/lab/v1/experiment/group/statistics-detail', { params })
}

// 更新群组数据信息
export function updateGroupStatistics(data: { id: string }) {
  return httpRequest.post('/api/lab/v1/experiment/group/statistics-user-group', data)
}

// 获取群组成员
export function getGroupMembers(params: { group_id: string; name?: string; id?: string }) {
  return httpRequest.get('/api/lab/v1/experiment/group/members', { params })
}

// 清空静态群组成员
export function clearGroupMembers(data: { group_id: string }) {
  return httpRequest.post('/api/lab/v1/experiment/group/clear-members', data)
}

// 搜索群组成员
export function searchGroupMembers(params: { group_id: string; name?: string; id?: string }) {
  return httpRequest.get('/api/lab/v1/experiment/group/search-members', { params })
}

// 手动添加静态群组
export function addGroupMembers(data: { group_id: string; user_ids: string[] }) {
  return httpRequest.post('/api/lab/v1/experiment/group/add-members', data)
}
