import { defineStore } from 'pinia'

export const useStore = defineStore('main', {
  state: () => {
    return {
      layers: {
        messageToEdit: '',
        elements: {},
        messages: [
          { id: 'simple-textc9xkhtp5yypo7qsnp9e1gh', type: 'simple-text', subtitle: 'bbb', color: '#000000' },
          { id: 'simple-textfuxp9gjvnc78ru0n1tkhul', type: 'simple-text', subtitle: 'aaa', color: '#000000' }
        ],
        default_values: {
          image:
            'https://images.unsplash.com/photo-1545703399-4313b14625d9?ixlib=rb-4.0.3&ixid=MnwxMjA3fDB8MHxleHBsb3JlLWZlZWR8NHx8fGVufDB8fHx8&w=1000&q=80',
          video: 'https://drive.google.com/uc?export=view&confirm=yTib&id=1g8uCFA1CDKMvVsPwb8V8ayk-3Mop3_Hu'
        }
      }
    }
  },
  getters: {
    getMessages: state => {
      return () => state.layers.messages
    },
    getMessageById: state => {
      return messageId => state.layers.messages.find(element => element.id == messageId)
    },
    getItemById: state => {
      return (messageId, itemId) => state.getMessageById(messageId).items.find(element => element.id == itemId)
    },
    getDefaultValues: state => {
      return () => state.layers.default_values
    }
  },
  actions: {
    setMessageItems(messageId, items) {
      let result = this.layers.messages.find(element => element.id === messageId)
      result.items = items
    }
  }
})
