import type { IMenuItem } from '@/types'
import { defineStore } from 'pinia'
import IconMetadata from '@/components/icon/IconMetadata.vue'
import IconConnect from '@/components/icon/IconConnect.vue'
import IconUser from '@/components/icon/IconUser.vue'
import IconLabel from '@/components/icon/IconLabel.vue'
import IconGroup from '@/components/icon/IconGroup.vue'
import IconMaterial from '@/components/icon/IconMaterial.vue'
import IconTrip from '@/components/icon/IconTrip.vue'
import IconAnalyze from '@/components/icon/IconAnalyze.vue'
import IconText from '@/components/icon/IconText.vue'
import IconImage from '@/components/icon/IconImage.vue'
import IconAudio from '@/components/icon/IconAudio.vue'
import IconVideo from '@/components/icon/IconVideo.vue'
import IconH5 from '@/components/icon/IconH5.vue'
import IconQrcode from '@/components/icon/IconQrcode.vue'
import IconMiniProgram from '@/components/icon/IconMiniProgram.vue'
import IconCard from '@/components/icon/IconCard.vue'

interface State {
  menus: IMenuItem[]
}

// 学生菜单
const menus: IMenuItem[] = [
  {
    name: '元数据管理',
    path: '/metadata',
    icon: markRaw(IconMetadata),
    children: [
      { name: '用户属性管理', path: '/metadata/user' },
      { name: '事件属性管理', path: '/metadata/event' }
    ]
  },
  {
    name: '连接管理',
    path: '/connect',
    icon: markRaw(IconConnect)
  },
  {
    name: '用户管理',
    path: '/user',
    icon: markRaw(IconUser)
  },
  {
    name: '标签管理',
    path: '/label',
    icon: markRaw(IconLabel)
  },
  {
    name: '群组管理',
    path: '/group',
    icon: markRaw(IconGroup)
  },
  {
    name: '营销资料管理',
    path: '/material',
    icon: markRaw(IconMaterial),
    children: [
      { name: '文本资料管理', path: '/material/text', icon: markRaw(IconText) },
      { name: '图片资料管理', path: '/material/image', icon: markRaw(IconImage) },
      { name: '语音资料管理', path: '/material/audio', icon: markRaw(IconAudio) },
      { name: '视频资料管理', path: '/material/video', icon: markRaw(IconVideo) },
      { name: 'H5资料管理', path: '/material/h5', icon: markRaw(IconH5) },
      { name: '二维码资料管理', path: '/material/qrcode', icon: markRaw(IconQrcode) },
      { name: '小程序资料管理', path: '/material/mini', icon: markRaw(IconMiniProgram) },
      { name: '卡券资料管理', path: '/material/card', icon: markRaw(IconCard) }
    ]
  },
  {
    name: '用户旅程',
    path: '/trip',
    icon: markRaw(IconTrip),
    children: [
      { name: '我的用户旅程', path: '/trip/my' },
      { name: '旅程模板管理', path: '/trip/template' }
    ]
  },
  {
    name: '报表分析',
    path: '/analyze',
    icon: markRaw(IconAnalyze)
  }
]

export const useMenuStore = defineStore({
  id: 'menu',
  state: (): State => ({
    menus
  })
})
