import httpRequest from '@/utils/axios'

// 链接列表
export function getConnectionList(params: { created_operator?: string; type?: string; page?: number; page_size?: number }) {
  return httpRequest.get('/api/experiment/v1/experiment/connection/list', { params: { experiment_id: '7025368348925886464', ...params } })
}

// 创建链接
export function createConnection(data: { type: string; config_attributes: string; }) {
  return httpRequest.post('/api/experiment/v1/experiment/connection/create', { experiment_id: '7025368348925886464', ...data })
}

// 链接详情
export function getConnectionDetails(params: { id?: string; }) {
  return httpRequest.get('/api/experiment/v1/experiment/connection/view', { params: { experiment_id: '7025368348925886464', ...params } })
}

// 更新链接
export function updateConnection(data: { id: string; config_attributes: string; }) {
  return httpRequest.post('/api/experiment/v1/experiment/connection/update', { experiment_id: '7025368348925886464', ...data })
}

// 删除链接
export function deleteConnection(data: { id: string; }) {
  return httpRequest.post('/api/experiment/v1/experiment/connection/delete', { experiment_id: '7025368348925886464', ...data })
}