import httpRequest from '@/utils/axios'

// 用户属性列表
export function getMemberMeta(params: { name?: string; status?: string; type?: string; page?: number; page_size?: number }) {
  return httpRequest.get('/api/experiment/v1/experiment/meta-member/list', { params: { experiment_id: '7025368348925886464', ...params } })
}

// 用户属性详情
export function getMemberMetaDetail(params: { id: string }) {
  return httpRequest.get('/api/experiment/v1/experiment/meta-member/view', { params: { experiment_id: '7025368348925886464', ...params } })
}

// 创建用户属性
export function createMemberMeta(data: { name: string; english_name: string; type: string; format: string; status: string; }) {
  return httpRequest.post('/api/experiment/v1/experiment/meta-member/create', { experiment_id: '7025368348925886464', ...data })
}

// 修改用户属性
export function updateMemberMeta(data: { id?: string; name: string; english_name: string; status: string; }) {
  return httpRequest.post('/api/experiment/v1/experiment/meta-member/update', { experiment_id: '7025368348925886464', ...data })
}

// 修改用户属性
export function deleteMemberMeta(data: { id: string; }) {
  return httpRequest.post('/api/experiment/v1/experiment/meta-member/delete', { experiment_id: '7025368348925886464', ...data })
}

// 事件属性列表
export function getMetaEvent(params: { name?: string; status?: string; type?: string; page?: number; page_size?: number }) {
  return httpRequest.get('/api/experiment/v1/experiment/meta-event/list', { params: { experiment_id: '7025368348925886464', ...params } })
}