import httpRequest from '@/utils/axios'

// 获取实验直播商品属性的列表
export function getAttrList(params?: { name?: string }) {
  return httpRequest.get('/api/lab/v1/experiment/live-commodity-attr/list', { params })
}

// 获取实验直播商品属性详情
export function getAttr(params: { id: string }) {
  return httpRequest.get('/api/lab/v1/experiment/live-commodity-attr/detail', { params })
}

// 创建实验直播商品属性
export function createAttr(data: { pid: string; name: string; status: string }) {
  return httpRequest.post('/api/lab/v1/experiment/live-commodity-attr/create', data)
}

// 更新实验直播商品属性详情
export function updateAttr(data: { id: string; name: string; status: string }) {
  return httpRequest.post('/api/lab/v1/experiment/live-commodity-attr/update', data)
}

// 删除实验直播商品属性
export function deleteAttr(data: { id: string }) {
  return httpRequest.post('/api/lab/v1/experiment/live-commodity-attr/delete', data)
}
