import httpRequest from '@/utils/axios'

// 获取实验直播话术的列表
export function getTalkList(params?: {
  name?: string
  live_commodity_id?: string
  live_commodity_type_id?: string
  live_commodity_title?: string
}) {
  return httpRequest.get('/api/lab/v1/experiment/live-speeches/list', { params })
}

// 获取实验直播话术详情
export function getTalk(params: { id: string }) {
  return httpRequest.get('/api/lab/v1/experiment/live-speeches/detail', { params })
}

// 创建实验直播话术
export function createTalk(data: { pid: string; name: string; status: string }) {
  return httpRequest.post('/api/lab/v1/experiment/live-speeches/create', data)
}

// 更新实验直播话术详情
export function updateTalk(data: { id: string; name: string; status: string }) {
  return httpRequest.post('/api/lab/v1/experiment/live-speeches/update', data)
}

// 删除实验直播话术
export function deleteTalk(data: { id: string }) {
  return httpRequest.post('/api/lab/v1/experiment/live-speeches/delete', data)
}

// 获取实验直播商品详情
export function getProduct(params: { id: string }) {
  return httpRequest.get('/api/lab/v1/experiment/live-commodity/detail', { params })
}
