import httpRequest from '@/utils/axios'

// 新建资料
export function createMaterial(data: any) {
  return httpRequest.post('/api/lab/v1/experiment/marketing-ai/create', data)
}

// 更新资料
export function updateMaterial(data: any) {
  return httpRequest.post('/api/lab/v1/experiment/marketing-ai/update', data)
}

// 资料列表
export function getMaterialList(params?: { name: string; type: string; way: string; id: string; status: string; updated_operator: string }) {
  return httpRequest.get('/api/lab/v1/experiment/marketing-ai/list', { params })
}

// 资料详情
export function getMaterial(params: { id: string }) {
  return httpRequest.get('/api/lab/v1/experiment/marketing-ai/detail', { params })
}

// 删除资料
export function deleteMaterial(data: { id: string }) {
  return httpRequest.post('/api/lab/v1/experiment/marketing-ai/delete', data)
}

// 获取所属行业列表
export function getIndustryList() {
  return httpRequest.get('/api/lab/v1/experiment/marketing-ai/industries')
}

// 获取实验下绑定的所有连接
export function getConnectionList() {
  return httpRequest.get('/api/lab/v1/experiment/marketing-ai/connections')
}

// 获取天工AI的使用详情
export function getAIUsage(params: { marketing_material_id: string }) {
  return httpRequest.get('/api/lab/v1/experiment/marketing-ai/ai-usage-detail', { params })
}

// 天工AI-聊天
export function postAIChat(data: { marketing_material_id: string; context: string; type: number; chart_id: string | null }) {
  return httpRequest.post('/api/lab/v1/experiment/marketing-ai/sky-agents-chat', data)
}

// 天工3.0文字生成图片
export function postGenerateImage(data: { marketing_material_id: string; context: string; type: number; chart_id: string | null }) {
  return httpRequest.post('/api/lab/v1/experiment/marketing-ai/sky-agent3-generate-image', data)
}

// 创客贴-查询我的设计(排序+筛选)
export function getChuanKitDesignList(data: { user_flag: string; page_no: number; page_size: number; time_order: number }) {
  return httpRequest.post('/api/lab/v1/experiment/marketing-ai/chuangkit-designs', data)
}
// 创客贴-服务端图片获取
export function getChuanKitSourceImage(data: { userFlag: string; designId: string }) {
  return httpRequest.post('/api/lab/v1/experiment/marketing-ai/chuangkit-source-image', data)
}
