// import fs from 'node:fs'
// import path from 'node:path'
import { fileURLToPath, URL } from 'node:url'

import { defineConfig } from 'vite'
import vue from '@vitejs/plugin-vue'
import checker from 'vite-plugin-checker'
import AutoImport from 'unplugin-auto-import/vite'
import ReactivityTransform from '@vue-macros/reactivity-transform/vite'
import mkcert from 'vite-plugin-mkcert'

export default defineConfig(({ mode }) => ({
  base: mode === 'prod' ? 'https://webapp-pub.ezijing.com/website/prod/saas-dml/' : '/',
  plugins: [
    mkcert(),
    vue(),
    AutoImport({
      imports: ['vue', 'vue-router', '@vueuse/core'],
      dts: true,
      eslintrc: { enabled: true },
    }),
    ReactivityTransform(),
    checker({ vueTsc: true, eslint: { useFlatConfig: true, lintCommand: 'eslint "./src/**/*.{vue,js,jsx,ts,tsx}"' } }),
  ],
  server: {
    open: true,
    host: 'dev.ezijing.com',
    // https: {
    //   key: fs.readFileSync(path.join(__dirname, './https/ezijing.com.key')),
    //   cert: fs.readFileSync(path.join(__dirname, './https/ezijing.com.pem'))
    // },
    proxy: {
      '/api/tiangong': {
        target: 'https://api.singularity-ai.com',
        changeOrigin: true,
        rewrite: (path) => path.replace(/^\/api\/tiangong/, ''),
      },
      '/api/deepseek': {
        target: 'https://api.deepseek.com',
        changeOrigin: true,
        rewrite: (path) => path.replace(/^\/api\/deepseek/, ''),
      },
      '/api/qwen': {
        target: 'https://dashscope.aliyuncs.com',
        changeOrigin: true,
        rewrite: (path) => path.replace(/^\/api\/qwen/, ''),
      },
      '/api/qianfan': {
        target: 'https://aip.baidubce.com',
        changeOrigin: true,
        rewrite: (path) => path.replace(/^\/api\/qianfan/, ''),
      },
      '/api/duan': {
        target: 'https://saas-ai.ezijing.com',
        changeOrigin: true,
        // rewrite: (path) => path.replace(/^\/api\/duan/, ''),
      },
      // '/api/lab': {
      //   target: 'http://local-com-resource-api.frontend.ezijing.com',
      //   changeOrigin: true,
      //   rewrite: (path) => path.replace(/^\/api\/lab/, ''),
      // },
      '/api': 'https://saas-dml.ezijing.com',
    },
  },
  resolve: {
    alias: {
      '@': fileURLToPath(new URL('./src', import.meta.url)),
    },
  },
  css: {
    preprocessorOptions: {
      scss: { api: 'modern-compiler' },
    },
  },
}))
