import { getMetaUserAttrList, getMetaEventList, getTagList, getConnectionList } from '@/api/base'

// 用户属性类型
export interface AttrType {
  id: string
  name: string
  type: string
  format: string
  english_name: string
  pinyin: string
}
// 事件类型
interface MetaEventType {
  id: string
  name: string
  english_name: string
  pinyin: string
  event_attrs: AttrType[]
}

// 标签类型
export interface TagType {
  id: string
  name: string
}

// 连接类型
export interface ConnectionType {
  id: string
  name: string
  type: string
  status: '0' | '1'
  config_attributes: any
}

// 所有用户属性
const userAttrList = ref<AttrType[]>([])
export function useUserAttr() {
  function fetchUserAttrList() {
    getMetaUserAttrList({ check_role: true }).then((res: any) => {
      userAttrList.value = res.data.items
    })
  }
  onMounted(() => {
    if (!userAttrList.value?.length) fetchUserAttrList()
  })
  return { fetchUserAttrList, userAttrList }
}

// 所有事件
const metaEventList = ref<MetaEventType[]>([])
export function useMetaEvent() {
  function fetchMetaEventList() {
    getMetaEventList({ check_role: true }).then((res: any) => {
      metaEventList.value = res.data.items
    })
  }
  onMounted(() => {
    if (!metaEventList.value?.length) fetchMetaEventList()
  })
  return { fetchMetaEventList, metaEventList }
}

// 所有标签
const tagList = ref<TagType[]>([])
export function useTag() {
  function fetchTagList() {
    getTagList({ check_role: 1 }).then((res: any) => {
      tagList.value = res.data.items
    })
  }
  onMounted(() => {
    if (!tagList.value?.length) fetchTagList()
  })
  return { fetchTagList, tagList }
}

// 所有连接
const connectionList = ref<ConnectionType[]>([])
export function useConnection() {
  function fetchConnectionList() {
    getConnectionList().then((res: any) => {
      connectionList.value = res.data.items.map((item: any) => {
        const attrs = JSON.parse(item.config_attributes)
        const name = Array.isArray(attrs) ? attrs.find((item: any) => item.prop === 'name')?.value : attrs.name
        return { ...item, config_attributes: attrs, name }
      })
    })
  }
  onMounted(() => {
    if (!connectionList.value?.length) fetchConnectionList()
  })
  return { fetchConnectionList, connectionList }
}
