import httpRequest from '@/utils/axios'

// 人员列表
export function getMemberList(params: { name?: string; id?: string; mobile?: string; status?: string; page?: number; page_size?: number }) {
  return httpRequest.get('/api/lab/v1/experiment/member/list', { params })
}

// 链接列表
export function getMemberConnectionsList() {
  return httpRequest.get('/api/lab/v1/experiment/member/connections')
}

// 用户属性
export function getMemberFieldsList() {
  return httpRequest.get('/api/lab/v1/experiment/member/member-fields')
}

// 新建用户
export function createMember(data: { name: string; status: string; experiment_connection_id: string; gender: string; mobile: string; fields: string }) {
  return httpRequest.post('/api/lab/v1/experiment/member/create', data)
}

// 删除用户
export function deleteMember(data: { ids: string; }) {
  return httpRequest.post('/api/lab/v1/experiment/member/delete', data)
}

// 新建用户
export function updateMember(data: { id?: string; name: string; status: string; experiment_connection_id: string; gender: string; mobile: string; fields: string }) {
  return httpRequest.post('/api/lab/v1/experiment/member/update', data)
}

// 单人员事件列表
export function getMemberEventList(params: { id: string; page?: number; page_size?: number }) {
  return httpRequest.get('/api/lab/v1/experiment/member/member-events', { params })
}

// 事件列表
export function getEventList() {
  return httpRequest.get('/api/lab/v1/experiment/member/events')
}

// 新建事件
export function createEvent(data: { experiment_member_id: string; experiment_meta_event_id: string; fields: any }) {
  return httpRequest.post('/api/lab/v1/experiment/member/event-create', data)
}

// 更新事件
export function updateEvent(data: { id: string; fields: any }) {
  return httpRequest.post('/api/lab/v1/experiment/member/event-update', data)
}

// 删除事件
export function deleteEvent(data: { id: string }) {
  return httpRequest.post('/api/lab/v1/experiment/member/event-delete', data)
}

// 用户画像
export function getMemberImage(params: { id: string }) {
  return httpRequest.get('/api/lab/v1/experiment/member/member-image', { params })
}

// 导入事件
export function importEvent(data: { event_id: string; file: any }) {
  return httpRequest.post('/api/lab/v1/experiment/member/event-upload', data, {
    headers: { 'Content-Type': 'multipart/form-data' }
  })
}

// 导入用户
export function importMember(data: { groups_id?: string; connection_id: string; file: any }) {
  return httpRequest.post('/api/lab/v1/experiment/member/member-upload', data, {
    headers: { 'Content-Type': 'multipart/form-data' }
  })
}

// 用户画像
export function getMemberGroups() {
  return httpRequest.get('/api/lab/v1/experiment/member/groups')
}