import type { RouteRecordRaw } from 'vue-router'
import Layout from '@/components/layout/Index.vue'

const routes: RouteRecordRaw[] = [
  {
    path: '/live',
    redirect: '/live/test',
  },
  {
    path: '/live/test',
    component: Layout,
    children: [
      { path: '', component: () => import('./views/Index.vue') },
      { path: 'demo', component: () => import('./views/Demo.vue') },
      { path: 'view', component: () => import('./views/View.vue') },
      { path: 'reply', component: () => import('./views/Reply.vue') },
    ],
  },
  {
    path: '/one/live/test/view',
    component: () => import('./views/Demo.vue'),
    props: { isView: true },
  },
]

export { routes }
