import { getExperiment, getConnections, getMemberAttrs, getEvents, checkStep } from '../api'
import { getNameByValue } from '@/utils/dictionary'
import { useMapStore } from '@/stores/map'
const connectionTypeList = useMapStore().getMapValuesByKey('experiment_connection_type')
const attrTypeList = useMapStore().getMapValuesByKey('experiment_attribute_type')

// 实验信息
export interface Experiment {
  id: number
  name: string
  length: string
  course_name: string
  teacher_name: string
}
const experiment = ref<Partial<Experiment>>({})
export function useExperiment() {
  async function fetchInfo() {
    const res = await getExperiment()
    const detail = res.data.detail
    const course = detail.courses?.map((item: any) => item.name) || []
    const teacher = detail.teachers?.map((item: any) => item.name) || []
    experiment.value = { ...detail, course_name: course.join('、'), teacher_name: teacher.join('、') }
  }
  onMounted(() => {
    fetchInfo()
  })
  return { experiment }
}

// 链接
export interface Connection {
  id: string
  type: string
  type_name: string
  member_count: string
  event_count: string
}
const connections = ref<Connection[]>([])
export function useConnection() {
  async function fetchInfo() {
    const res = await getConnections()
    connections.value = res.data.items.map((item: any) => {
      return { ...item, type_name: getNameByValue(item.type, connectionTypeList) }
    })
  }
  onMounted(() => {
    fetchInfo()
  })
  return { connections }
}

// 用户属性
export interface MemberAttr {
  id: string
  name: string
  english_name: string
  type: string
  format: string
}
const memberAttrs = ref<MemberAttr[]>([])
export function useMemberAttrs() {
  async function fetchInfo() {
    const res = await getMemberAttrs()
    memberAttrs.value = res.data.items.map((item: any) => {
      return { ...item, type_name: getNameByValue(item.type, attrTypeList) }
    })
  }
  onMounted(() => {
    fetchInfo()
  })
  return { memberAttrs }
}

// 事件
export interface EventAttr {
  id: string
  name: string
  english_name: string
}
const events = ref<EventAttr[]>([])
export function useEvents() {
  async function fetchInfo() {
    const res = await getEvents()
    events.value = res.data.items
  }
  onMounted(() => {
    fetchInfo()
  })
  return { events }
}

export function useCheckStep(type: number) {
  const isCheck = ref(false)
  onMounted(async () => {
    const res = await checkStep({ type })
    isCheck.value = res.data.is_check
  })
  return { isCheck }
}
