import httpRequest from '@/utils/axios'

// 链接列表
export function getConnectionList(params: { created_operator?: string; type?: string; page?: number; 'per-page'?: number }) {
  return httpRequest.get('/api/lab/v1/experiment/connection/list', { params })
}

// 创建链接
export function createConnection(data: { type: string; config_attributes: any }) {
  return httpRequest.post('/api/lab/v1/experiment/connection/create', data)
}

// 链接详情
export function getConnectionDetails(params: { id?: string }) {
  return httpRequest.get('/api/lab/v1/experiment/connection/view', { params })
}

// 更新链接
export function updateConnection(data: { id: string; config_attributes: any }) {
  return httpRequest.post('/api/lab/v1/experiment/connection/update', data)
}

// 删除链接
export function deleteConnection(data: { id: string }) {
  return httpRequest.post('/api/lab/v1/experiment/connection/delete', data)
}

// 卷王获取表单列表
export function getSurveyFormList(params: { id: string }) {
  return httpRequest.get('/api/lab/v1/experiment/connection/survey-form-list', { params })
}

// 卷王获取表单详情
export function getSurveyForm(params: { form_id: string }) {
  return httpRequest.get('/api/lab/v1/experiment/connection/survey-form-view', { params })
}

// 卷王字段映射保存
export function submitSurveyForm(data: { id: string; form_id: string; form: string }) {
  return httpRequest.post('/api/lab/v1/experiment/connection/save-survey-form-view', data)
}

// 获取公众号第三方授权操作地址
export function getWechatAuth(params: { connection_id: string; auth_type?: 1 | 2 | 3; redirect_uri: string }) {
  return httpRequest.get('/api/lab/v1/experiment/wechat-platform/auth', { params })
}

// 同步授权方公众号信息到本地
export function asyncOfficialAccountInfo(params: { connection_id: string; appid: string }) {
  return httpRequest.get('/api/lab/v1/experiment/wechat-platform/async-official-account', { params })
}

// 同步微信公众号用户到本地
export function asyncOfficialAccountUsers(params: { connection_id: string; appid: string }) {
  return httpRequest.get('/api/lab/v1/experiment/wechat-platform/async-official-account-users', { params })
}

// 获取生成用户数据
export function getScheduleMember(params: {
  experiment_id: string; connect_id
  : string
}) {
  return httpRequest.get('/api/lab/v1/experiment/connection/schedule-member', { params })
}

// 生成用户数据保存
interface ScheduleMember {
  experiment_id: string
  connect_id: string
  size: number
  cover_type: number
  name: number
  name_value?: string
  status: number
  gender: number
  mobile: number
  create_data: string
}
export function submitScheduleMember(data: ScheduleMember) {
  return httpRequest.post('/api/lab/v1/experiment/connection/schedule-member', data)
}

// 获取生成事件数据
export function getScheduleEvent(params: {
  experiment_id: string; connect_id
  : string;
  event_id: string
}) {
  return httpRequest.get('/api/lab/v1/experiment/connection/schedule-event', { params })
}

// 生成用户数据保存
interface ScheduleEvent {
  experiment_id: string
  connect_id: string
  event_id: number
  member_rate: number
  size: number
  cover_type: number
  create_data: string
  other_fields: string
}
export function submitScheduleEvent(data: ScheduleEvent) {
  return httpRequest.post('/api/lab/v1/experiment/connection/schedule-event', data)
}

// 获取数据进度
export function getScheduleList(params: {
  experiment_id: string
}) {
  return httpRequest.get('/api/lab/v1/experiment/connection/schedule-list', { params })
}

// 删除进度
export function scheduleDelete(data: { id: string }) {
  return httpRequest.post('/api/lab/v1/experiment/connection/schedule-delete', data)
}

// 用户触达信息
export function getStudentFollow(params: {
  experiment_id: string
  experiment_connection_id: string
}) {
  return httpRequest.get('/api/lab/v1/experiment/connection/student-follow', { params })
}

// 用户触达提交表单信息
export function studentSubmitForm(data: { experiment_connection_id: any; gender: string; name: string; mobile: string }) {
  return httpRequest.post('/api/lab/v1/experiment/connection/student-submit-form', data)
}

// 用户触达提交聊天信息
export function studentSubmitLog(data: { experiment_connection_id: any; logs: string }) {
  return httpRequest.post('/api/lab/v1/experiment/connection/student-submit-log', data)
}
