import type { Component } from 'vue'

export interface IMenuItem {
  tag?: string | string[]
  name: string
  path: string
  icon?: Component
  children?: IMenuItem[]
}

// 用户信息
export interface UserType {
  id: string
  mobile: string
  name: string
  email: string
  username: string
  avatar: string
}

// 项目信息
export interface ProjectType {
  id: string
  tab: string
  name: string
}

// 机构信息
export interface OrganizationType {
  id: string
  name: string
  contact_name: string
  contact_information: string
  validity_date: string
  is_valid: 1 | 2
}

// 角色信息
export interface RoleType {
  id: string
  name: string
  desc: string
}

// 权限信息
export interface PermissionType {
  desc: string
  effect_uris: string
  id: string
  name: string
  parent_id: string
  system_tag: number
  type: number
  tag: string
}

export interface SystemDictionary {
  id: string
  label: string
  value: string
}

// 操作人
export interface Operator {
  avatar: string
  id: string
  nickname: string
  real_name: string
  username: string
}

// 用户规则
export interface UserAttrRule {
  current_logic_operate: 'and' | 'or'
  items: RuleAttr[]
}

export interface RuleAttr {
  attr_id: string
  attr: string
  attr_name: string
  attr_type: string
  operate: string
  operate_name: string
  value: any
}

// 事件规则
export interface EventRule {
  current_logic_operate: 'and' | 'or'
  items: EventRuleItem[]
}

export interface EventRuleItem {
  happen_info: {
    is_happened: boolean
    event_id: string
    event_name: string
    attr_list: RuleAttr[]
  }
  trigger_info: {
    operate: string
    operate_name: string
    value: string
  }
}

// 标签规则
export interface TagRule {
  current_logic_operate: 'and' | 'or'
  items: string[]
}

// 用户行为规则
export interface UserActionRule {
  current_logic_operate: 'and' | 'or'
  items: UserActionRuleItem[]
}

export interface UserActionRuleItem {
  operate: string
  operate_name: string
  value: string
  event_list: RuleEvent[]
}

export interface RuleEvent {
  event_id: string
  event_name: string
  attr_list: RuleAttr[]
}

// 资料管理
export interface MaterialProp {
  id: string
  name: string
  content: string
  type_name: string
  type: string
  status_name: string
  status: string
  isView: boolean
}
