import httpRequest from '@/utils/axios'

// 获取用户信息
export function getUser() {
  return httpRequest.get('/api/lab/v1/common/permission/role')
}

// 退出登录
export function logout() {
  return httpRequest.get('/api/passport/rest/logout')
}

// 获取oss token
export function getToken() {
  return httpRequest.get('/api/usercenter/aliyun/assume-role')
}

// 获取oss signature
export function getSignature() {
  return httpRequest.get('/api/usercenter/aliyun/get-signature')
}

// 图片上传
export function uploadFile(data: Record<string, any>) {
  return httpRequest
    .post('https://webapp-pub.oss-cn-beijing.aliyuncs.com', data, {
      withCredentials: false,
      headers: { 'Content-Type': 'multipart/form-data' }
    })
    .then(() => data)
}
// 获取公共字典列表
export function getMapList() {
  return httpRequest.get('/api/resource/v1/util/get-data-dictionary-list')
}

// 获取上传视频凭证
export function getUploadVideoAuth(data: { title: string; file_name: string }) {
  return httpRequest.post('/api/lab/v1/teacher/video/auth-create', data)
}

// 刷新上传视频的地址凭证
export function updateUploadVideoAuth(data: { source_id: string }) {
  return httpRequest.post('/api/lab/v1/teacher/video/create-auth', data)
}

// 获取实验下的所有用户属性
export function getMetaUserAttrList() {
  return httpRequest.get('/api/lab/v1/experiment/meta-member/all')
}
// 获取实验下的所有事件
export function getMetaEventList() {
  return httpRequest.get('/api/lab/v1/experiment/meta-event/all')
}

// 获取实验下的所有标签
export function getTagList(params?: { check_role?: 0 | 1 }) {
  return httpRequest.get('/api/lab/v1/experiment/tag/all', { params })
}

// 获取实验下的所有连接
export function getConnectionList() {
  return httpRequest.get('/api/lab/v1/experiment/connection/all')
}

// 搜索紫荆用户
export function searchUser(params: any) {
  return httpRequest.get('/api/lab/v1/experiment/system/search-user', { params })
}

// 新建资料
export function createMaterial(data: { name: string; type: string; content: string; status: string }) {
  return httpRequest.post('/api/lab/v1/experiment/marketing-material/create', data)
}

// 更新资料
export function updateMaterial(data: { name: string; content: string; status: string }) {
  return httpRequest.post('/api/lab/v1/experiment/marketing-material/update', data)
}

// 资料列表
export function getMaterialList(params?: { name: string; type: string; id: string; status: string; updated_operator: string }) {
  return httpRequest.get('/api/lab/v1/experiment/marketing-material/list', { params })
}

// 删除资料
export function deleteMaterial(data: { id: string }) {
  return httpRequest.post('/api/lab/v1/experiment/marketing-material/delete', data)
}