import httpRequest from '@/utils/axios'
import type { TripTemplateListRequest, TripTemplateCreateRequest, TripTemplateUpdateRequest } from './types'

// 获取旅程模板列表
export function getTripTemplateList(params: TripTemplateListRequest) {
  return httpRequest.get('/api/lab/v1/experiment/itinerary/list', { params })
}

// 创建旅程模板
export function createTripTemplate(data: TripTemplateCreateRequest) {
  return httpRequest.post('/api/lab/v1/experiment/itinerary/create', data)
}

// 更新旅程模板
export function updateTripTemplate(data: TripTemplateUpdateRequest) {
  return httpRequest.post('/api/lab/v1/experiment/itinerary/update', data)
}

// 获取旅程连接
export function getTripConnections(params: { itinerary_id: string }) {
  return httpRequest.get('/api/lab/v1/experiment/itinerary/connections', { params })
}

// 旅程绑定连接
export function bindTripConnections(data: { itinerary_id: string; connection_ids: string[] }) {
  return httpRequest.post('/api/lab/v1/experiment/itinerary/bind-connections', data)
}
