export interface ConnectionsProp {
  id: string
  type: string
  type_name: string
}

export interface MemberFieldsProp {
  id: string
  name: string
  english_name: string
  type: string
  type_name: string
  format: string
  value: string
  isShow: boolean
}

export interface MemberProp {
  id: string
  name: string
  status: string
  experiment_connection_id: string
  gender: string
  mobile: string
  fields: string
  isView?: boolean
  connection_name: string
  status_name: string
}

export interface EventProp {
  name: string
  id: string
  attributes: AttributesProp[]
  connection_name: string
}

export interface AttributesProp {
  name: string
  id: string
  type: string
  format: string
  value: string
  experiment_meta_event_id: string
  fields: string
  connection_id: string
  isView: boolean
}

export interface ImageProp {
  name: string
  connection_name: string
  id: string
  created_time: string
  status_name: string
  status: string
  updated_time: string
  tag: string[]
  static_groups: string[]
  dynamic_groups: string[]
  events: {
    list: {
      updated_time: string
      connection_type: string
      connection_name: string
      event_name: string
    }[]
  }
}


