import { createRouter, createWebHistory } from 'vue-router'
import { useUserStore } from '@/stores/user'

const router = createRouter({
  history: createWebHistory(),
  routes: [{ path: '/:pathMatch(.*)*', redirect: '/' }]
})

router.beforeEach(async (to, from, next) => {
  const whiteList = ['/401']
  const user = useUserStore()
  if (!user.isLogin && !whiteList.includes(to.path)) {
    try {
      await user.getUser()
    } catch (e) {
      console.error(e)
    }
    if (!user.isLogin) {
      next('/401')
      return
    }
  }
  if (!to.query.experiment_id) {
    next({ path: to.path, query: { ...to.query, experiment_id: from.query.experiment_id || '7025368348925886464' } })
  } else {
    next()
  }
})

export default router
