import type { Operator } from '@/types'

// 标签类型
export interface LabelType {
  id: string
  name: string
  url: string
  is_default?: boolean
}

export type LabelTypeListRequest = Pick<LabelType, 'id' | 'name'> & { experiment_id?: string }

export type LabelTypeUpdateRequest = Pick<LabelType, 'id' | 'name' | 'url'> & { experiment_id?: string }

export type LabelTypeCreateRequest = Omit<LabelTypeUpdateRequest, 'id'>

// 标签
export interface Label {
  id: string
  name: string
  type_id: string
  status: string
  update_status: string // '1' | '2'
  update_rule: string
  tag_type: LabelType
  created_time: string
  created_operator: Operator
  updated_time: string
  updated_operator: Operator
  label: string
  weight: string
}
// 标签更新规则
export interface LabelUpdateRule {
  type: 1 | 2 | 3
  info: number
}

export type LabelListRequest = Pick<Label, 'id' | 'name'> & { experiment_id?: string }

export type LabelUpdateRequest = Pick<Label, 'id' | 'name' | 'type_id' | 'update_status' | 'update_rule' | 'status' | 'label'> & {
  experiment_id?: string
}

export type LabelCreateRequest = Omit<LabelUpdateRequest, 'id'>
