import type { IMenuItem } from '@/types'
import { defineStore } from 'pinia'
import { useUserStore } from '@/stores/user'

import IconMetadata from '@/components/icon/IconMetadata.vue'
import IconConnect from '@/components/icon/IconConnect.vue'
import IconUser from '@/components/icon/IconUser.vue'
import IconGroup2 from '@/components/icon/IconGroup2.vue'
import IconUser2 from '@/components/icon/IconUser2.vue'
import IconLabel from '@/components/icon/IconLabel.vue'
import IconGroup from '@/components/icon/IconGroup.vue'
import IconMaterial from '@/components/icon/IconMaterial.vue'
import IconTrip from '@/components/icon/IconTrip.vue'
import IconAnalyze from '@/components/icon/IconAnalyze.vue'
import IconText from '@/components/icon/IconText.vue'
import IconImage from '@/components/icon/IconImage.vue'
import IconAudio from '@/components/icon/IconAudio.vue'
import IconVideo from '@/components/icon/IconVideo.vue'
import IconH5 from '@/components/icon/IconH5.vue'
import IconQrcode from '@/components/icon/IconQrcode.vue'
import IconMiniProgram from '@/components/icon/IconMiniProgram.vue'
import IconCard from '@/components/icon/IconCard.vue'
import IconEvent from '@/components/icon/IconEvent.vue'

interface State {
  studentMenus: IMenuItem[]
  adminMenus: IMenuItem[]
}

// 学生菜单
const studentMenus: IMenuItem[] = [
  {
    name: '基础配置',
    path: '/connect',
    icon: markRaw(IconMetadata),
    children: [
      {
        name: '连接管理',
        path: '/connect',
        icon: markRaw(IconConnect)
      }
    ]
  },
  {
    name: '用户画像',
    path: '/user',
    icon: markRaw(IconUser)
  },
  {
    name: '用户识别',
    path: '/label',
    icon: markRaw(IconGroup2),
    children: [
      {
        name: '标签管理',
        path: '/label',
        icon: markRaw(IconLabel)
      },
      {
        name: '群组管理',
        path: '/group',
        icon: markRaw(IconGroup)
      }
    ]
  },
  {
    name: '营销内容设计',
    path: '/material',
    icon: markRaw(IconMaterial),
    children: [
      {
        name: '文本资料管理',
        path: '/material?type=1',
        icon: markRaw(IconText),
        // tag: 'v1-experiment-marketing-material-list'
        tag: ''
      },
      {
        name: '图片资料管理',
        path: '/material?type=2',
        icon: markRaw(IconImage),
        // tag: 'v1-experiment-marketing-material-list'
        tag: ''
      },
      {
        name: '卡券资料管理',
        path: '/material?type=8',
        icon: markRaw(IconCard),
        // tag: 'v1-experiment-marketing-material-list'
        tag: ''
      },
      {
        name: '语音资料管理',
        path: '/material?type=3',
        icon: markRaw(IconAudio),
        // tag: 'v1-experiment-marketing-material-list'
        tag: ''
      },
      {
        name: '视频资料管理',
        path: '/material?type=4',
        icon: markRaw(IconVideo),
        // tag: 'v1-experiment-marketing-material-list'
        tag: ''
      },
      { name: 'H5资料管理', path: '/material?type=5', icon: markRaw(IconH5), tag: 'v1-experiment-marketing-material-list' },
      {
        name: '二维码资料管理',
        path: '/material?type=6',
        icon: markRaw(IconQrcode),
        // tag: 'v1-experiment-marketing-material-list'
        tag: ''
      },
      {
        name: '小程序资料管理',
        path: '/material?type=7',
        icon: markRaw(IconMiniProgram),
        // tag: 'v1-experiment-marketing-material-list'
        tag: ''
      }
    ]
  },
  {
    name: '自动化营销',
    path: '/trip/my',
    icon: markRaw(IconTrip)
  },
  {
    name: '数据分析',
    path: '/analyze',
    icon: markRaw(IconAnalyze),
    children: [
      { name: '用户分析', path: '/analyze/user' },
      { name: '标签群组分析', path: '/analyze/label' },
      { name: '事件分析', path: '/analyze/event' },
      { name: '营销分析', path: '/analyze/marketing' }
    ]
  }
]

const adminMenus: IMenuItem[] = [
  {
    name: '基础配置',
    path: '/connect',
    icon: markRaw(IconMetadata),
    children: [
      {
        name: '连接管理',
        path: '/connect',
        icon: markRaw(IconConnect),
        tag: 'v1-experiment-connection'
      },
      {
        name: '用户属性管理',
        path: '/metadata/user',
        icon: markRaw(IconUser2),
        tag: 'v1-experiment-meta-member'
      },
      {
        name: '事件属性管理',
        path: '/metadata/event',
        icon: markRaw(IconEvent),
        tag: 'v1-experiment-meta-event'
      }
    ]
  },
  {
    name: '用户画像',
    path: '/user',
    icon: markRaw(IconUser),
    tag: 'v1-experiment-member'
  },
  {
    name: '用户识别',
    path: '/label',
    icon: markRaw(IconGroup2),
    children: [
      {
        name: '标签管理',
        path: '/label',
        icon: markRaw(IconLabel),
        tag: 'experiment_tags'
      },
      {
        name: '群组管理',
        path: '/group',
        icon: markRaw(IconGroup),
        tag: 'experiment_groups'
      }
    ]
  },
  {
    name: '营销内容设计',
    path: '/material',
    icon: markRaw(IconMaterial),
    tag: 'v1-experiment-marketing-material',
    children: [
      {
        name: '文本资料管理',
        path: '/material?type=1',
        icon: markRaw(IconText),
        tag: 'v1-experiment-marketing-material-list'
      },
      {
        name: '图片资料管理',
        path: '/material?type=2',
        icon: markRaw(IconImage),
        tag: 'v1-experiment-marketing-material-list'
      },
      {
        name: '卡券资料管理',
        path: '/material?type=8',
        icon: markRaw(IconCard),
        tag: 'v1-experiment-marketing-material-list'
      },
      {
        name: '语音资料管理',
        path: '/material?type=3',
        icon: markRaw(IconAudio),
        tag: 'v1-experiment-marketing-material-list'
      },
      {
        name: '视频资料管理',
        path: '/material?type=4',
        icon: markRaw(IconVideo),
        tag: 'v1-experiment-marketing-material-list'
      },
      { name: 'H5资料管理', path: '/material?type=5', icon: markRaw(IconH5), tag: 'v1-experiment-marketing-material-list' },
      {
        name: '二维码资料管理',
        path: '/material?type=6',
        icon: markRaw(IconQrcode),
        tag: 'v1-experiment-marketing-material-list'
      },
      {
        name: '小程序资料管理',
        path: '/material?type=7',
        icon: markRaw(IconMiniProgram),
        tag: 'v1-experiment-marketing-material-list'
      }
    ]
  },
  {
    name: '自动化营销',
    path: '/trip',
    icon: markRaw(IconTrip),
    tag: 'experiment_itinerary'
    // children: [{ name: '旅程模板管理', path: '/trip/template', tag: 'experiment_itinerary_list' }]
  },
  {
    name: '数据分析',
    path: '/analyze',
    icon: markRaw(IconAnalyze),
    children: [
      { name: '用户分析', path: '/analyze/user' },
      { name: '标签群组分析', path: '/analyze/label' },
      { name: '事件分析', path: '/analyze/event' },
      { name: '营销分析', path: '/analyze/marketing' }
    ]
  }
]

export const useMenuStore = defineStore({
  id: 'menu',
  state: (): State => ({
    studentMenus,
    adminMenus
  }),
  getters: {
    menus: state => {
      const userStore = useUserStore()
      if (userStore.role?.id === 1) {
        return state.studentMenus
      } else {
        return state.adminMenus
      }
    }
  }
})
