export interface Dictionary {
  label: string
  value: string | number
}

export function getNameByValue(value: string | number, list: Dictionary[]) {
  return list.find(item => item.value == value)?.label || value
}

// 旅程类型
export const tripTemplateTypeList = [
  { label: '自由旅程', value: '1' },
  { label: '固定旅程', value: '2' }
]

// 群组类型
export const groupTypeList = [
  { label: '静态群组', value: '1' },
  { label: '动态群组', value: '2' },
  { label: 'RFM群组', value: '3' }
]

// 更新方式
export const updateStatusRuleList = [
  { label: '自动更新', value: '1' },
  { label: '手动更新', value: '2' }
]

// 更新状态
export const updateStatusList = [
  { label: '未开始', value: '1' },
  { label: '进行中', value: '2' },
  { label: '完成', value: '3' },
  { label: '进行中', value: '4' }
]

export const dateUnitList = [
  { label: '天', value: 1 },
  { label: '周', value: 2 },
  { label: '月', value: 3 }
]

export const weekList = [
  { label: '周一', value: 1 },
  { label: '周二', value: 2 },
  { label: '周三', value: 3 },
  { label: '周四', value: 4 },
  { label: '周五', value: 5 },
  { label: '周六', value: 6 },
  { label: '周日', value: 7 }
]

export interface OperatorType {
  label: string
  value: string
  alias?: string
}

// 字符串
export const stringOperatorList: OperatorType[] = [
  { label: '等于', value: '=' },
  { label: '不等于', value: '!=' },
  { label: '包含', value: 'in' },
  { label: '不包含', value: 'not in' },
  { label: '空值', value: 'null' },
  { label: '非空', value: 'not null' }
]

// 整数|数字
export const numberOperatorList: OperatorType[] = [
  { label: '=', value: '=' },
  { label: '!=', value: '!=', alias: '≠' },
  { label: '>', value: '>' },
  { label: '>=', value: '>=', alias: '≥' },
  { label: '<', value: '<' },
  { label: '<=', value: '<=', alias: '≤' },
  { label: '区间', value: 'range' },
  { label: '空值', value: 'null' },
  { label: '非空', value: 'not null' }
]

// 日期
export const dateOperatorList: OperatorType[] = [
  { label: '绝对时间之前', value: 'before' },
  { label: '绝对时间之后', value: 'after' },
  { label: '绝对时间区间', value: 'range' },
  { label: '相对过去天数', value: 'relative_past_day' },
  { label: '相对当前天数', value: 'relative_current_day' },
  { label: '在...天内', value: 'in_day' }
]

export const happenInfoList = [
  { label: '发生过', value: true },
  { label: '未发生过', value: false }
]

export const triggerInfoList = [{ label: '触发次数', value: '触发次数' }]

export const labelList = [
  { label: '单属性标签', value: '5' },
  { label: '多属性标签', value: '6' },
  { label: '事件偏好标签 ', value: '2' },
  { label: '事件指标标签 ', value: '3' },
  { label: '自定义标签', value: '7' },
  { label: '分层标签 ', value: '1' },
  { label: 'RFM模型标签 ', value: '4' }
]

export const wayList = [
  { label: '总金额 ', value: '1' },
  { label: '总次数 ', value: '2' },
  { label: '平均金额 ', value: '3' }
]

export const materialMethodList = [
  { label: '离线上传 ', value: '2' },
  { label: '在线AI', value: '1' },
  { label: '在线设计', value: '3' }
]

// 使用场景
export const materialUsageList = [
  { label: '用户拉新 ', value: '1' },
  { label: '产品宣传 ', value: '2' },
  { label: '用户关怀 ', value: '3' },
  { label: '系统通知 ', value: '4' }
]

// 使用人员
export const materialUsersList = [
  { label: '销售人员 ', value: '1' },
  { label: '品牌人员 ', value: '2' },
  { label: '客服人员 ', value: '3' },
  { label: '运维人员 ', value: '4' },
  { label: '机器系统 ', value: '5' }
]

// 图片风格
export const materialPictureStyleList = [
  { label: '商务风格 ', value: '1' },
  { label: '扁平化 ', value: '2' },
  { label: '清新文艺 ', value: '3' },
  { label: '古典中国风 ', value: '4' },
  { label: '创意简约风 ', value: '5' },
  { label: '艺术插画 ', value: '6' },
  { label: '大气渐变 ', value: '7' },
  { label: '手绘水彩风 ', value: '8' },
  { label: '时尚杂志风 ', value: '9' },
  { label: '漫画风格 ', value: '10' }
]

// 文本用途
export const textPurposeList = [
  { label: '消息/短息', value: '1' },
  { label: '长文本/文章 ', value: '2' },
  { label: '短视频脚本 ', value: '3' }
]
