import httpRequest from '@/utils/axios'

// 获取用户信息
export function getUser() {
  return httpRequest.get('/api/lab/v1/common/permission/role')
}

// 获取旅程的数据使用状态(是否使用公共数据)
// true 是学员且使用公共数据（学员不能自己创建数据） false 学员可以自己创建数据
export function checkDataStatus() {
  return httpRequest.get('/api/lab/v1/experiment/itinerary/check-data-status')
}

// 退出登录
export function logout() {
  return httpRequest.get('/api/passport/rest/logout')
}

// 获取oss token
export function getToken() {
  return httpRequest.get('/api/usercenter/aliyun/assume-role')
}

// 获取oss signature
export function getSignature() {
  return httpRequest.get('/api/usercenter/aliyun/get-signature')
}

// 图片上传
export function uploadFile(data: Record<string, any>) {
  return httpRequest
    .post(data.host || 'https://webapp-pub.ezijing.com', data, {
      withCredentials: false,
      headers: { 'Content-Type': 'multipart/form-data' }
    })
    .then(() => data)
}

// 获取公共字典列表
export function getMapList() {
  return httpRequest.get('/api/resource/v1/util/get-data-dictionary-list')
}

// 获取上传视频凭证
export function getUploadVideoAuth(data: { title: string; file_name: string }) {
  return httpRequest.post('/api/lab/v1/teacher/video/auth-create', data)
}

// 刷新上传视频的地址凭证
export function updateUploadVideoAuth(data: { source_id: string }) {
  return httpRequest.post('/api/lab/v1/teacher/video/create-auth', data)
}

// 获取实验下的所有用户属性
export function getMetaUserAttrList(params?: { check_role?: boolean }) {
  return httpRequest.get('/api/lab/v1/experiment/meta-member/all', { params })
}
// 获取实验下的所有事件
export function getMetaEventList(params?: { check_role?: boolean }) {
  return httpRequest.get('/api/lab/v1/experiment/meta-event/all', { params })
}

// 获取实验下的所有标签
export function getTagList(params?: { check_role?: 0 | 1 }) {
  return httpRequest.get('/api/lab/v1/experiment/tag/all', { params })
}

// 获取实验下的所有连接
export function getConnectionList() {
  return httpRequest.get('/api/lab/v1/experiment/connection/all')
}

// 搜索紫荆用户
export function searchUser(params: any) {
  return httpRequest.get('/api/lab/v1/experiment/system/search-user', { params })
}

// 新建资料
export function createMaterial(data: { name: string; type: string; content: string; status: string }) {
  return httpRequest.post('/api/lab/v1/experiment/marketing-material/create', data)
}

// 更新资料
export function updateMaterial(data: { name: string; content: string; status: string }) {
  return httpRequest.post('/api/lab/v1/experiment/marketing-material/update', data)
}

// 资料列表
export function getMaterialList(params?: { name: string; type: string; id: string; status: string; updated_operator: string }) {
  return httpRequest.get('/api/lab/v1/experiment/marketing-material/list', { params })
}

// 删除资料
export function deleteMaterial(data: { id: string }) {
  return httpRequest.post('/api/lab/v1/experiment/marketing-material/delete', data)
}

// 用户属性搜索
export function searchMetaMemberAttrs(params?: { search: string; member_meta_id?: string; page?: number; per_page?: number }) {
  return httpRequest.get('/api/lab/v1/experiment/meta-member/search-attributes', { params })
}

// 事件属性列表
export function getMemberEvents() {
  return httpRequest.get('/api/lab/v1/experiment/member/events')
}

// 用户属性搜索
export function searchEventAttrs(params?: {
  search: string
  experiment_meta_event_id?: string
  experiment_meta_event_attr_id?: string
  page?: number
  per_page?: number
}) {
  return httpRequest.get('/api/lab/v1/experiment/event/search-attributes', { params })
}

// 获取分片大小和唯一文件名
export function getLocalFileChunk(params: { file_size: number; file_name: string }) {
  return httpRequest.get('/api/lab/v1/common/file/chunk', { params })
}

// 上传每个分片前请求接口来获取当前文件是否超时,之前的分片是否被清理,如果被请求则拒绝处理。返回客户端错误码，让客户端户端不再续传剩余分片
// 1文件被清理 0文件未被清理
export function checkLocalFile(params: { file_name: string }) {
  return httpRequest.get('/api/lab/v1/common/file/check', { params })
}

// 上传文件
export function uploadLocalFile(data: { file: File; file_name: string; is_continuingly?: number; now_package_num: number; total_package_num: number }) {
  return httpRequest.post('/api/lab/v1/common/file/upload', data, {
    withCredentials: false,
    headers: { 'Content-Type': 'multipart/form-data' }
  })
}
