export interface Dictionary {
  label: string
  value: string | number
}

export function getNameByValue(value: string | number, list: Dictionary[]) {
  return list.find(item => item.value == value)?.label || value
}

// 旅程类型
export const tripTemplateTypeList = [
  { label: '自由旅程', value: '1' },
  { label: '固定旅程', value: '2' }
]

// 群组类型
export const groupTypeList = [
  { label: '静态群组', value: '1' },
  { label: '动态群组', value: '2' }
]

// 更新方式
export const updateStatusRuleList = [
  { label: '自动更新', value: '1' },
  { label: '手动更新', value: '2' }
]

// 更新状态
export const updateStatusList = [
  { label: '未开始', value: '1' },
  { label: '进行中', value: '2' },
  { label: '完成', value: '3' },
  { label: '进行中', value: '4' }
]

export const dateUnitList = [
  { label: '天', value: 1 },
  { label: '周', value: 2 },
  { label: '月', value: 3 }
]

export const weekList = [
  { label: '周一', value: 1 },
  { label: '周二', value: 2 },
  { label: '周三', value: 3 },
  { label: '周四', value: 4 },
  { label: '周五', value: 5 },
  { label: '周六', value: 6 },
  { label: '周日', value: 7 }
]

export interface OperatorType {
  label: string
  value: string
  alias?: string
}

// 字符串
export const stringOperatorList: OperatorType[] = [
  { label: '等于', value: '=' },
  { label: '不等于', value: '!=' },
  { label: '包含', value: 'in' },
  { label: '不包含', value: 'not in' },
  { label: '空值', value: 'null' },
  { label: '非空', value: 'not null' }
]

// 整数|数字
export const numberOperatorList: OperatorType[] = [
  { label: '=', value: '=' },
  { label: '!=', value: '!=', alias: '≠' },
  { label: '>', value: '>' },
  { label: '>=', value: '>=', alias: '≥' },
  { label: '<', value: '<' },
  { label: '<=', value: '<=', alias: '≤' },
  { label: '区间', value: 'range' },
  { label: '空值', value: 'null' },
  { label: '非空', value: 'not null' }
]

// 日期
export const dateOperatorList: OperatorType[] = [
  { label: '绝对时间之前', value: 'before' },
  { label: '绝对时间之后', value: 'after' },
  { label: '绝对时间区间', value: 'range' },
  { label: '相对过去天数', value: 'relative_past_day' },
  { label: '相对当前天数', value: 'relative_current_day' },
  { label: '在...天内', value: 'in_day' }
]

export const happenInfoList = [
  { label: '发生过', value: true },
  { label: '未发生过', value: false }
]

export const triggerInfoList = [{ label: '触发次数', value: '触发次数' }]
