import type { Operator } from '@/types'

// 策略
export interface Strategy {
  id: string
  name: string
  type: string
  industry: string
  status: string
  update_status: string // '1' | '2'
  update_rule: string
  created_time: string
  created_operator: Operator
  updated_time: string
  updated_operator: Operator
}
// 策略更新规则
export interface StrategyUpdateRule {
  type: 1 | 2 | 3
  info: number
}

export type StrategyListRequest = Pick<Strategy, 'id' | 'name'> & { experiment_id?: string }

export type StrategyUpdateRequest = Pick<
  Strategy,
  'id' | 'name' | 'type' | 'industry' | 'status' | 'update_status' | 'update_rule'
> & {
  experiment_id?: string
}

export type StrategyCreateRequest = Omit<StrategyUpdateRequest, 'id'>
