import httpRequest from '@/utils/axios'

// 获取实验详情
export function getExperiment() {
  return httpRequest.get('/api/lab/v1/experiment/once/experiment')
}

// 获取用户性别
export function getMemberGender(params: { sso_id: string }) {
  return httpRequest.get('/api/lab/v1/experiment/analyse/gender', { params })
}

// 获取用户来源
export function getMemberConnections(params: { sso_id: string }) {
  return httpRequest.get('/api/lab/v1/experiment/analyse/connections', { params })
}

// 获取用户状态
export function getMemberStatus(params: { sso_id: string }) {
  return httpRequest.get('/api/lab/v1/experiment/analyse/member-status', { params })
}

// 获取用户元数据属性
export function getMemberAttrs(params: { sso_id: string; member_meta_id: string }) {
  return httpRequest.get('/api/lab/v1/experiment/analyse/member-attrs', { params })
}

// 获取用户元数据属性
export function getMemberMetaAttrs() {
  return httpRequest.get('/api/lab/v1/experiment/analyse/member-meta-attrs')
}

// 获取指定用户的标签
export function getUserTags(params: { sso_id: string; limit: number }) {
  return httpRequest.get('/api/lab/v1/experiment/analyse/user-tags', { params })
}
